% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gr-TPS.R
\name{tps_iso}
\alias{tps_iso}
\title{Deformation isolines using Thin Plate Splines.}
\usage{
tps_iso(
  fr,
  to,
  amp = 1,
  grid = FALSE,
  over = 1.2,
  palette = col_spring,
  iso.nb = 1000,
  iso.levels = 12,
  cont = TRUE,
  cont.col = "black",
  poly = TRUE,
  shp = TRUE,
  shp.border = col_qual(2),
  shp.lwd = c(2, 2),
  shp.lty = c(1, 1),
  legend = TRUE,
  legend.text,
  ...
)
}
\arguments{
\item{fr}{The reference \eqn{(x; y)} coordinates}

\item{to}{The target \eqn{(x; y)} coordinates}

\item{amp}{An amplification factor of differences between \code{fr} and
\code{to}}

\item{grid}{whether to calculate and plot changes across the graphical window
\code{TRUE} or just within the starting shape (\code{FALSE})}

\item{over}{A \code{numeric} that indicates how much the thin plate splines
extends over the shapes}

\item{palette}{A color palette such those included in Momocs or produced
with \link{colorRampPalette}}

\item{iso.nb}{A \code{numeric}. The number of points to use for the
calculation of deformation}

\item{iso.levels}{\code{numeric}. The number of levels for mapping the
deformations}

\item{cont}{\code{logical}. Whether to draw contour lines}

\item{cont.col}{A color for drawing the contour lines}

\item{poly}{whether to draw polygons (for outlines) or points (for landmarks)}

\item{shp}{\code{logical}. Whether to draw shapes}

\item{shp.border}{Two colors for drawing the borders}

\item{shp.lwd}{Two \code{lwd} for drawing shapes}

\item{shp.lty}{Two \code{lty} fro drawing the shapes}

\item{legend}{logical whether to plot a legend}

\item{legend.text}{some text for the legend}

\item{...}{additional arguments to feed \link{coo_draw}}
}
\value{
No returned value
}
\description{
\code{tps_iso} calculates deformations between two configurations and map
them with or without isolines.
}
\examples{
botF <- efourier(bot)
x <- MSHAPES(botF, 'type', nb.pts=80)$shp
fr <- x$beer
to <- x$whisky
tps_iso(fr, to, iso.nb=200, amp=3)
tps_iso(fr, to, iso.nb=200, amp=3, grid=TRUE)
}
\seealso{
Other thin plate splines: 
\code{\link{tps2d}()},
\code{\link{tps_arr}()},
\code{\link{tps_grid}()},
\code{\link{tps_raw}()}
}
\concept{thin plate splines}
