% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mte.R
\name{integralMTE}
\alias{integralMTE}
\title{Integrating MTEs}
\usage{
integralMTE(fx)
}
\arguments{
\item{fx}{An \code{"motbf"} object of subclass \code{'mte'}.}
}
\value{
The non-defined integral of the function.
}
\description{
Method to calculate the non-defined integral of an \code{"motbf"} object of \code{'mte'} 
subclass.
}
\examples{

## 1. EXAMPLE
X <- rexp(1000)
Px <- univMoTBF(X, POTENTIAL_TYPE="MTE")
integralMTE(Px)

## 2. EXAMPLE
X <- rnorm(1000)
Px <- univMoTBF(X, POTENTIAL_TYPE="MTE")
integralMTE(Px)

\dontrun{
## 3. EXAMPLE
X <- rnorm(1000)
Px <- univMoTBF(X, POTENTIAL_TYPE="MOP")
integralMTE(Px)
## Error in integralMTE(Px): fx is an 'motbf' function but not 'mte' subclass.
class(Px)
subclass(Px)
}
}
\seealso{
\link{univMoTBF} for learning and \link{integralMoTBF} 
for a more complete function to get defined and non-defined integrals
of class \code{"motbf"}.
}
