% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Inference.R
\name{is.discrete}
\alias{is.discrete}
\title{Check discreteness of a node}
\usage{
is.discrete(node, bn)
}
\arguments{
\item{node}{A character (name of node) or numeric (index of node in the bn list) input.}

\item{bn}{A list of lists obtained from \link{MoTBFs_Learning}.}
}
\value{
\code{is.discrete} returns \code{TRUE} or \code{FALSE} depending on whether the node is discrete or not.
}
\description{
This function allows to check whether a node is discrete or not
}
\examples{
 

## Create a dataset
  # Continuous variables
  x <- rnorm(100)
  y <- rnorm(100)
  
  # Discrete variable
  z <- sample(letters[1:2],size = 100, replace = TRUE)
  
  data <- data.frame(C1 = x, C2 = y, D1 = z, stringsAsFactors = FALSE)
  
## Get DAG
  dag <- LearningHC(data)

## Learn BN
  bn <- MoTBFs_Learning(dag, data, POTENTIAL_TYPE = "MTE")

## Check wheter a node is discrete or not

  # Using its name
  is.discrete("D1", bn)
  
  # Using its index position
  is.discrete(3, bn)  
}
