% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Inference.R
\name{parentValues}
\alias{parentValues}
\title{Value of Parent Nodes}
\usage{
parentValues(node, bn, obs, rdf)
}
\arguments{
\item{node}{A \code{character} string that represents the node's name.}

\item{bn}{A list of lists obtained from the function \link{MoTBFs_Learning}. It contains the conditional density functions of the bayesian network.}

\item{obs}{A \code{data.frame} of dimension '1xm' containing an instance of the 'm' variables that belong to the evidence set.}

\item{rdf}{A \code{data.frame} of dimension '1xk' containing an instance of the 'k' variables sampled from the bayesian network.}
}
\value{
A \code{data.frame} containing the values of the parents of 'node'.
}
\description{
This function returns a \code{data.frame} of dimension '1xn' containing the values of the 'n' parents of a 'node' of interest. 
Use this function if you have a random sample and an observed sample with information about the parents.
The values of the parents are obtained from the evidence set unless they are not observed. In this case, the values are taken from the random sample.
}
\examples{

## Dataset
  data("ecoli", package = "MoTBFs")
  data <- ecoli[,-c(1,9)]

## Get directed acyclic graph
  dag <- LearningHC(data)
  
## Learn bayesian network
  bn <- MoTBFs_Learning(dag, data = data, numIntervals = 4, POTENTIAL_TYPE = "MTE")
  
## Specify the evidence set
  obs <- data.frame(lip = "1", alm1 = 0.5, stringsAsFactors=FALSE)
  
## Create a random sample
  contData <- data[ ,which(lapply(data, is.numeric) == TRUE)]
  fx <- lapply(contData, univMoTBF, POTENTIAL_TYPE = "MTE")
  disData <- data[ ,which(lapply(data, is.numeric) == FALSE)]
  conSample <- lapply(fx, rMoTBF, size = 1)
  disSample <- lapply(unique(disData), sample, size = 1)
  
  rdf <- as.data.frame(list(conSample,disSample), stringsAsFactors = FALSE)
  
## Get the values of the parents of node "alm2"
  parentValues("alm2", bn, obs, rdf)

}
