% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MoTBFClass.R
\name{Class-MoTBF}
\alias{Class-MoTBF}
\alias{motbf}
\alias{print.motbf}
\alias{as.character.motbf}
\alias{as.list.motbf}
\alias{is.motbf}
\title{Class \code{"motbf"}}
\usage{
motbf(x = 0)

\method{print}{motbf}(x, ...)

\method{as.character}{motbf}(x, ...)

\method{as.list}{motbf}(x, ...)

is.motbf(x, class = "motbf")
}
\arguments{
\item{x}{Preferably, a list containing, an \code{'mte'} or \code{'mop'} univariate expression
and other posibles elements like a \code{"numeric"} vector with the domain of the variable, 
the number of iterations needed to solve the optimization problem, among others.
Any \R object can be entered, but the utility of this function is not to transform
objects of other classes into objects of class \code{"motbf"}.}

\item{...}{Additional arguments, not needed for these methods.}

\item{class}{By default is \code{"motbf"}.}
}
\description{
Defines an object of class \code{"motbf"} and other basis functions for manipulating 
\code{"motbf"} objects.
}
\examples{
## Subclass 'MOP'
param <- c(1,2,3,4,5)
MOPString <- asMOPString(param)
fMOP <- motbf(MOPString)
print(fMOP) ## fMOP
as.character(fMOP)
as.list(fMOP)
is(fMOP) 
is.motbf(fMOP)

## Subclass 'MTE'
param <- c(6,7,8,9,10)
MTEString <- asMTEString(param)
fMTE <- motbf(MTEString)
print(fMTE) ## MTE
as.character(fMTE)
as.list(fMTE)
is(fMTE) 
is.motbf(fMTE)
}
\seealso{
\link{asMOPString} and \link{asMTEString}
}
