% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getCoverage.R
\name{getCoverage}
\alias{getCoverage}
\title{Get sample-specific coverage files for each sample-cell population.}
\usage{
getCoverage(
  popFrags,
  normFactor,
  TxDb,
  cl,
  filterEmpty = FALSE,
  verbose = FALSE
)
}
\arguments{
\item{popFrags}{GRangesList of fragments for all sample/cell populations}

\item{normFactor}{Normalization factor. Can be either be one, in which case all coverage files will be normalized by the same value, or the same length as the GRangesList}

\item{TxDb}{The TxDb-class transcript annotation
package for your organism (e.g. "TxDb.Hsapiens.UCSC.hg38.refGene"). This
must be installed. See
\href{https://bioconductor.org/packages/release/data/annotation/}{
Bioconductor AnnotationData Packages}.}

\item{cl}{cl argument to \code{\link[pbapply]{pblapply}}}

\item{filterEmpty}{True/False flag on whether or not to carry forward regions without coverage.}

\item{verbose}{Boolean variable to determine verbosity of output.}
}
\value{
popCounts A GRangesList of coverage for each sample and cell population
}
\description{
getCoverage takes the output of MOCHA::getPopFrags and returns
 a GRanges of singe-basepair resolution coverage.
}
