% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/merge_Risoe.BINfileData.R
\name{merge_Risoe.BINfileData}
\alias{merge_Risoe.BINfileData}
\title{Merge Risoe.BINfileData objects or Risoe BIN-files}
\usage{
merge_Risoe.BINfileData(
  input.objects,
  output.file,
  keep.position.number = FALSE,
  position.number.append.gap = 0
)
}
\arguments{
\item{input.objects}{\link{character} with \linkS4class{Risoe.BINfileData} objects (\strong{required}):
Character vector with path and files names
(e.g. \code{input.objects = c("path/file1.bin", "path/file2.bin")} or
\linkS4class{Risoe.BINfileData} objects (e.g. \code{input.objects = c(object1, object2)}).
Alternatively a \code{list} is supported.}

\item{output.file}{\link{character} (\emph{optional}):
File output path and name. If no value is given, a \linkS4class{Risoe.BINfileData} is
returned instead of a file.}

\item{keep.position.number}{\link{logical} (\emph{with default}):
Allows keeping the original position numbers of the input objects.
Otherwise the position numbers are recalculated.}

\item{position.number.append.gap}{\link{integer} (\emph{with default}):
Set the position number gap between merged BIN-file sets, if the option
\code{keep.position.number = FALSE} is used. See details for further
information.}
}
\value{
Returns a \code{file} or a \linkS4class{Risoe.BINfileData} object.
}
\description{
Function allows merging Risoe BIN/BINX files or \code{Risoe.BINfileData} objects.
}
\details{
The function allows merging different measurements to one file or one
object. The record IDs are recalculated for the new object. Other values
are kept for each object. The number of input objects is not limited.

\code{position.number.append.gap} option

If the option \code{keep.position.number = FALSE} is used, the position
numbers of the new data set are recalculated by adding the highest position
number of the previous data set to the each position number of the next data
set. For example: The highest position number is 48, then this number will
be added to all other position numbers of the next data set (e.g. 1 + 48 =
49)

However, there might be cases where an additional addend (summand) is needed
before the next position starts. Example:
\itemize{
\item Position number set (A): \verb{1,3,5,7}
\item Position number set (B): \verb{1,3,5,7}
}

With no additional summand the new position numbers would be:
\verb{1,3,5,7,8,9,10,11}. That might be unwanted. Using the argument
\code{position.number.append.gap = 1} it will become:
\verb{1,3,5,7,9,11,13,15,17}.
}
\note{
The validity of the output objects is not further checked.
}
\section{Function version}{
 0.2.7
}

\examples{

##merge two objects
data(ExampleData.BINfileData, envir = environment())

object1 <- CWOSL.SAR.Data
object2 <- CWOSL.SAR.Data

object.new <- merge_Risoe.BINfileData(c(object1, object2))

} 

\section{How to cite}{
Kreutzer, S., 2021. merge_Risoe.BINfileData(): Merge Risoe.BINfileData objects or Risoe BIN-files. Function version 0.2.7. In: Kreutzer, S., Burow, C., Dietze, M., Fuchs, M.C., Schmidt, C., Fischer, M., Friedrich, J., Mercier, N., Philippe, A., Riedesel, S., Autzen, M., Mittelstrass, D., Gray, H.J., 2021. Luminescence: Comprehensive Luminescence Dating Data Analysis. R package version 0.9.15. https://CRAN.R-project.org/package=Luminescence
}

\references{
Duller, G., 2007. Analyst.
}
\seealso{
\linkS4class{Risoe.BINfileData}, \link{read_BIN2R}, \link{write_R2BIN}
}
\author{
Sebastian Kreutzer, Geography & Earth Sciences, Aberystwyth University (United Kingdom)
, RLum Developer Team}
\keyword{IO}
\keyword{manip}
