% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RLum.Data.Curve-class.R
\docType{class}
\name{RLum.Data.Curve-class}
\alias{RLum.Data.Curve-class}
\alias{show,RLum.Data.Curve-method}
\alias{set_RLum,RLum.Data.Curve-method}
\alias{get_RLum,RLum.Data.Curve-method}
\alias{length_RLum,RLum.Data.Curve-method}
\alias{names_RLum,RLum.Data.Curve-method}
\alias{bin_RLum.Data,RLum.Data.Curve-method}
\alias{smooth_RLum,RLum.Data.Curve-method}
\title{Class \code{"RLum.Data.Curve"}}
\usage{
\S4method{show}{RLum.Data.Curve}(object)

\S4method{set_RLum}{RLum.Data.Curve}(
  class,
  originator,
  .uid,
  .pid,
  recordType = NA_character_,
  curveType = NA_character_,
  data = matrix(0, ncol = 2),
  info = list()
)

\S4method{get_RLum}{RLum.Data.Curve}(object, info.object = NULL)

\S4method{length_RLum}{RLum.Data.Curve}(object)

\S4method{names_RLum}{RLum.Data.Curve}(object)

\S4method{bin_RLum.Data}{RLum.Data.Curve}(object, bin_size = 2)

\S4method{smooth_RLum}{RLum.Data.Curve}(object, k = NULL, fill = NA, align = "right", method = "mean")
}
\arguments{
\item{object}{\code{\link{get_RLum}}, \code{\link{length_RLum}}, \code{\link{names_RLum}} (\strong{required}):
an object of class \linkS4class{RLum.Data.Curve}}

\item{class}{\code{\link{set_RLum}}; \link{character} (\strong{required}):
name of the \code{RLum} class to create}

\item{originator}{\code{\link{set_RLum}}; \link{character} (\emph{automatic}):
contains the name of the calling function (the function that produces this object);
can be set manually.}

\item{.uid}{\code{\link{set_RLum}}; \link{character} (\emph{automatic}):
sets an unique ID for this object using the internal C++ function \code{create_UID}.}

\item{.pid}{\code{\link{set_RLum}}; \link{character} (\emph{with default}):
option to provide a parent id for nesting at will.}

\item{recordType}{\code{\link{set_RLum}}; \link{character} (\emph{optional}):
record type (e.g., "OSL")}

\item{curveType}{\code{\link{set_RLum}}; \link{character} (\emph{optional}):
curve type (e.g., "predefined" or "measured")}

\item{data}{\code{\link{set_RLum}}; \link{matrix} (\strong{required}):
raw curve data. If \code{data} itself is a \code{RLum.Data.Curve}-object this can be
used to re-construct the object (s. details), i.e. modified parameters except
\code{.uid}, \code{.pid} and \code{originator}. The rest will be subject to copy and paste unless provided.}

\item{info}{\code{\link{set_RLum}}; \link{list} (\emph{optional}):
info elements}

\item{info.object}{\code{\link{get_RLum}} \link{character} (\emph{optional}):
name of the wanted info element}

\item{bin_size}{\link{integer} (\emph{with default}):
set number of channels used for each bin, e.g. \code{bin_size = 2} means that
two channels are binned.}

\item{k}{\code{\link{smooth_RLum}}; \link{integer} (\emph{with default}):
window for the rolling mean; must be odd for \code{rollmedian}.
If nothing is set k is set automatically}

\item{fill}{\code{\link{smooth_RLum}}; \link{numeric} (\emph{with default}):
a vector defining the left and the right hand data}

\item{align}{\code{\link{smooth_RLum}}; \link{character} (\emph{with default}):
specifying whether the index of the result should be left- or right-aligned
or centred (default) compared to the rolling window of observations, allowed
\code{"right"}, \code{"center"} and \code{"left"}}

\item{method}{\code{\link{smooth_RLum}}; \link{character} (\emph{with default}):
defines which method should be applied for the smoothing: \code{"mean"} or \code{"median"}}
}
\value{
\strong{\code{set_RLum}}

Returns an \linkS4class{RLum.Data.Curve} object.

\strong{\code{get_RLum}}
\enumerate{
\item A \link{matrix} with the curve values or
\item only the info object if \code{info.object} was set.
}

\strong{\code{length_RLum}}

Number of channels in the curve (row number of the matrix)

**`names_RLum`**

Names of the info elements (slot `info`)

\strong{\code{bin_RLum.Data}}

Same object as input, after applying the binning.

\strong{\code{smooth_RLum}}

Same object as input, after smoothing
}
\description{
Class for representing luminescence curve data.
}
\section{Methods (by generic)}{
\itemize{
\item \code{show}: Show structure of \code{RLum.Data.Curve} object

\item \code{set_RLum}: Construction method for RLum.Data.Curve object. The slot info is optional
and predefined as empty list by default.

\item \code{get_RLum}: Accessor method for RLum.Data.Curve object. The argument info.object is
optional to directly access the info elements. If no info element name is
provided, the raw curve data (matrix) will be returned.

\item \code{length_RLum}: Returns the length of the curve object, which is the maximum of the
value time/temperature of the curve (corresponding to the stimulation length)

\item \code{names_RLum}: Returns the names info elements coming along with this curve object

\item \code{bin_RLum.Data}: Allows binning of specific objects

\item \code{smooth_RLum}: Smoothing of RLum.Data.Curve objects using the function \link[zoo:rollmean]{zoo::rollmean} or \link[zoo:rollmean]{zoo::rollmedian}.
In particular the internal function \code{.smoothing} is used.
}}

\section{Slots}{

\describe{
\item{\code{recordType}}{Object of class "character" containing the type of the curve (e.g. "TL" or "OSL")}

\item{\code{curveType}}{Object of class "character" containing curve type, allowed values are measured or predefined}

\item{\code{data}}{Object of class \link{matrix} containing curve x and y data.
'data' can also be of type \code{RLum.Data.Curve} to change object values without
deconstructing the object. For example:\preformatted{set_RLum(class = 'RLum.Data.Curve',
         data = Your.RLum.Data.Curve,
         recordType = 'never seen before')
}

would just change the \code{recordType}. Missing arguments  the value is taken
from the input object in 'data' (which is already an RLum.Data.Curve object
in this example)}
}}

\note{
The class should only contain data for a single curve. For additional
elements the slot \code{info} can be used (e.g. providing additional heating
ramp curve). Objects from the class \code{RLum.Data.Curve} are produced by other
functions (partly within \linkS4class{RLum.Analysis} objects),
namely: \link{Risoe.BINfileData2RLum.Analysis}, \link{read_XSYG2R}
}
\section{Create objects from this Class}{

Objects can be created by calls of the form
\code{set_RLum(class = "RLum.Data.Curve", ...)}.
}

\section{Class version}{
 0.5.1
}

\examples{

showClass("RLum.Data.Curve")

##set empty curve object
set_RLum(class = "RLum.Data.Curve")

}
\seealso{
\linkS4class{RLum}, \linkS4class{RLum.Data}, \link{plot_RLum}, \link{merge_RLum}
}
\author{
Sebastian Kreutzer, IRAMAT-CRP2A, UMR 5060, CNRS - Université Bordeaux Montaigne (France)
, RLum Developer Team} 

\section{How to cite}{
Kreutzer, S., 2021. RLum.Data.Curve-class(): Class 'RLum.Data.Curve'. In: Kreutzer, S., Burow, C., Dietze, M., Fuchs, M.C., Schmidt, C., Fischer, M., Friedrich, J., Mercier, N., Riedesel, S., Autzen, M., Mittelstrass, D., Gray, H.J., 2021. Luminescence: Comprehensive Luminescence Dating Data Analysis. R package version 0.9.11. https://CRAN.R-project.org/package=Luminescence
}

\keyword{classes}
\keyword{internal}
