#' Function to find complement of the original tree and find complement PIs ###
#' Internal Logic Forest Functions
#'
#' Function to find complement of the original tree and find complement PIs
#' This function is called by \code{pimp.import}. It is not intended to be used independently of this function.
#' @param tree An object of class \code{"logregtree"}
#' @returns ctree An object of class \code{"logregtree"} that is the complement of tree
#' @export
#' @keywords internal

find.ctree<-function(tree)
{
  conc<-ifelse(tree$trees$conc==3, 3, ifelse(tree$trees$conc==0, 0, 3-tree$trees$conc))
  neg<-ifelse(tree$trees$conc==3, 1-tree$trees$neg, 0)
  ctrees<-cbind(tree$trees$number, conc, tree$trees$knot, neg, tree$trees$pick)
  colnames(ctrees)<-c("number","conc","knot","neg","pick")
  ctrees<-as.data.frame(ctrees)
  ctree<-list(whichtree=tree$whichtree, coef=tree$coef, trees=ctrees)
  class(ctree)<-"logregtree"
  return(ctree)
}
