% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LibOPF.R
\name{opf_write_modelfile}
\alias{opf_write_modelfile}
\title{Writes into a file the trained OPF classifier}
\usage{
opf_write_modelfile(g, file)
}
\arguments{
\item{g}{The classifier object}

\item{file}{The file name to save the classifier}
}
\value{
`NULL`
}
\description{
Writes into a file the trained OPF classifier
}
\examples{
dat <- opf_read_subGraph(system.file("extdata/boat.dat",package = "LibOPF"))
X <- opf_split(dat,0.5,0,0.5,0)
T <- X$training
T2 <- X$testing
Y <- opf_train(T)
opf_write_modelfile(Y$classifier, file.path(tempdir(), "classifier.opf"))

}
