% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/handling_dataframes.R
\name{as.data.frame.JuliaProxy}
\alias{as.data.frame.JuliaProxy}
\title{Coerce a Julia Table to a Data Frame}
\usage{
\method{as.data.frame}{JuliaProxy}(x, ...)
}
\arguments{
\item{x}{a proxy object pointing to a Julia object that implements the interface
of the package Julia package \code{Tables}}

\item{...}{(not used)}
}
\description{
Get the data from a Julia proxy object that implements the Julia
\href{https://github.com/JuliaData/Tables.jl}{\code{Tables}} interface,
and create an R data frame from it.
}
\details{
Strings are not converted to factors.
}
\examples{
\dontshow{
   if (juliaSetupOk()) {
      Pkg <- juliaImport("Pkg")
      Pkg$activate(system.file("examples", "IndexedTables-Project",
                   package = "JuliaConnectoR"))
      Pkg$instantiate()
      # ignore warnings on Julia 1.0:
      capture.output(juliaImport("IndexedTables"), type = "message")
   }
}
if (juliaSetupOk()) {

   # Demonstrate the usage with the Julia package "IndexedTables" (v1.0)

   # Install the package first if it is not installed:
   # juliaEval('import Pkg; Pkg.add("IndexedTables")')

   # Import "IndexedTables" package
   IndexedTables <- juliaImport("IndexedTables")

   mydf <- data.frame(x = c(1, 2, 3),
                      y = c("a", "b", "c"),
                      z = c(TRUE, FALSE, NA),
                      stringsAsFactors = FALSE)

   # Create a table in Julia, e. g. via IndexedTables
   mytbl <- IndexedTables$table(mydf)

   # This table can, e g. be queried and
   # the result can be translated to an R data frame.
   seltbl <- IndexedTables$select(mytbl, juliaExpr("(:x, :y)"))[1:2]

   # Translate selection of Julia table into R data frame
   as.data.frame(seltbl)

}

\dontshow{
   if (juliaSetupOk()) {
      rm(mytbl, seltbl)
      JuliaConnectoR:::stopJulia()
   }
}
}
