% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FitCalibCoxRS.R, R/FitCalibCoxRSInts.R
\name{FitCalibCoxRS}
\alias{FitCalibCoxRS}
\alias{FitCalibCoxRSInts}
\title{Fitting Proportional Hazards Risk-Set Calibration Models with Covariates}
\usage{
FitCalibCoxRS(w, w.res, Q, hz.times, tm, n.int = 5, order = 2, event)

FitCalibCoxRSInts(w, w.res, Q, hz.times, n.int = 5, order = 2, tm, event,
  pts.for.ints)
}
\arguments{
\item{w}{A matrix of time points when measurements on the binary covariate were obtained.}

\item{w.res}{A matrix of measurement results of the binary covariate. It corresponds to the time points in \code{w}}

\item{Q}{Matrix of covariates for PH calibration model}

\item{hz.times}{Times used for calculating the baseline hazard function of a PH calibration model}

\item{tm}{Vector of observed main event time or censoring time}

\item{n.int}{The number of interior knots to be used, see \code{ICsurv::fast.PH.ICsurv.EM}, Default: 5}

\item{order}{the order of the basis functions. See \code{ICsurv::fast.PH.ICsurv.EM}, Default: 2}

\item{event}{Vector of censoring indicators. \code{1} for event \code{0} for censored}

\item{pts.for.ints}{Points defining the intervals for grouping risk-sets (first one has to be zero). Should be sorted from zero up.
\code{pts.for.ints} is used only for \code{FitCalibCoxRSInts}.}
}
\value{
A list of Cox PH model fits, each supplemented with the knots and order used for the I-splines.
}
\description{
\code{FitCalibCoxRS} fits proportional hazards risk-set calibration models for time-to-exposure from interval-censored data with covariates. The exposure is a binary covariate measured
in intermittent times. The covariates (\code{Q}) are associated with the time-to-exposure. This function fits a calibration model at each main event time point,
using only members of the risk set at that time point.
model is fitted (for all the data) and used for that time point.

\code{FitCalibCoxRSInts} fits proportional hazards grouped risk-set calibration models for time-to-exposure from interval-censored data with covariates. The exposure is a binary covariate measured
in intermittent times. The covariates (\code{Q}) are associated with the time-to-exposure. Unlike \code{FitCalibCoxRS}, this function fits a calibration model
at each of the given points for \code{pts.for.ints}.
}
\details{
In case of an error in the model-fitting at a certain time point, a proportional hazards calibration 
model (for all the data) is fitted and used for that time point.
}
\examples{
set.seed(2) 
sim.data <- ICcalib:::SimCoxIntervalCensCox(n.sample = 50, lambda = 0.1, 
                                            alpha = 0.25, beta0 = log(0.2),
                                            gamma.q = c(log(0.75), log(2.5)), 
                                            gamma.z = log(1.5), mu = 0.2, 
                                            n.points = 2)
# The baseline hazard for the calibration model is calculated in observation times
cox.hz.times <- sort(unique(sim.data$obs.tm)) 
# Fit proprtional hazards grouped risk-sets calibration models
calib.ph.rs.fit <- FitCalibCoxRSInts(w = sim.data$w, w.res = sim.data$w.res, Q = sim.data$Q, 
                                     hz.times = cox.hz.times, tm = sim.data$obs.tm, 
                                     event = sim.data$delta, pts.for.ints = seq(0, 3, 1.5),
                                     n.int = 5, order = 2)
# Below is a more time consuming option (no grouping of risk-sets)
# FitCalibCoxRS(w = sim.data$w, w.res = sim.data$w.res, Q = sim.data$Q, 
#                hz.times = cox.hz.times, obs.tm = sim.data$obs.tm, 
#               event = sim.data$delta, n.int = 5, order = 1)
}
\seealso{
\code{\link[ICsurv]{fast.PH.ICsurv.EM}},  \code{\link[ICcalib]{FitCalibCox}}

\code{\link[ICsurv]{fast.PH.ICsurv.EM}},  \code{\link[ICcalib]{FitCalibCox}}
}
