% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{charlson_sundararajan}
\alias{charlson_sundararajan}
\title{Charlson Comorbidities (Sundararajan)}
\format{
An object of class \code{spec_tbl_df} (inherits from \code{tbl_df}, \code{tbl}, \code{data.frame}) with 17 rows and 3 columns.
}
\source{
\doi{10.1016/j.jclinepi.2004.03.012}
}
\usage{
charlson_sundararajan
}
\description{
Specification of the Charlson comorbidity index
in the version of Sunhararahan et al. (2004).
}
\details{
The specification can be expanded using the \link{icd_expand}
function to return all corresponding ICD-10-GM codes.

This table was created on the basis of the publication
referenced below. It is provided as is with no guarantee
of accuracy. Furthermore, the applicability of the codes
in the context of the German ICD-10-GM is unclear.

\describe{
\item{Condition}{Disease entity}
\item{Weight}{Controbition of the disease entity towords the combined comorbidity index}
\item{ICD_10_AM}{Secification of the corresponding ICD-10 codes, suitable for input to \link{icd_expand}}
}
}
\seealso{
Other Charlson: 
\code{\link{charlson_rcs}}
}
\concept{Charlson}
\keyword{datasets}
