% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SimMixtureCop.R
\name{SimMixtureCop}
\alias{SimMixtureCop}
\title{Simulation of bivariate mixture copula model}
\usage{
SimMixtureCop(Q, family, KendallTau, n, DoF)
}
\arguments{
\item{Q}{Weights vector (1 x component);}

\item{family}{'gaussian' , 't' , 'clayton' , 'frank' , 'gumbel'}

\item{KendallTau}{Kendall's rank correlation}

\item{n}{number of simulated vectors}

\item{DoF}{vector of degree of freedom only for the Student copula}
}
\value{
\item{SimData}{Simulated Data}

\item{MC}{Markov chain regimes}

\item{alpha}{parameters alpha}
}
\description{
This function simulates observation from a bivariate mixture copula model
}
\examples{
Q <- matrix(c(0.8, 0.2),1,2) ; kendallTau <- c(0.3 ,0.7) ;
simulations <- SimMixtureCop(Q, 'gaussian', kendallTau, 300)



}
