% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/perf.meas.R
\docType{methods}
\name{multilabel.F.measure}
\alias{multilabel.F.measure}
\alias{F.measure.multilabel}
\alias{F.measure.multilabel,matrix,matrix-method}
\title{multilabel F-measure}
\usage{
F.measure.multilabel(target, predicted, b.per.example = FALSE)

\S4method{F.measure.multilabel}{matrix,matrix}(target, predicted, b.per.example = FALSE)
}
\arguments{
\item{target}{matrix with the target multilabel: rows correspond to examples and columns to classes.
\eqn{target[i,j]=1} if example \eqn{i} belongs to class \eqn{j}, \eqn{target[i,j]=0} otherwise.}

\item{predicted}{a numeric matrix with discrete predicted values: rows correspond to examples and columns to classes.
\eqn{predicted[i,j]=1} if example \eqn{i} is predicted belonging to class \eqn{j}, \eqn{target[i,j]=0} otherwise.}

\item{b.per.example}{a boolean value.
\itemize{
 \item \code{TRUE}: results are returned for each example;
 \item \code{FALSE}: only the average results are returned;
}}
}
\value{
Two different outputs respect to the input parameter \code{b.per.example}:
\itemize{
 \item \code{b.per.example==FALSE}: a list with a single element average. A named vector with average precision (P), recall (R),
  specificity (S), F-measure (F), average F-measure (avF) and Accuracy (A) across examples. F is the F-measure computed as the
  harmonic mean between the average precision and recall; av.F is the F-measure computed as average across examples;
 \item \code{b.per.example==FALSE}: a list with two elements:
  \enumerate{
    \item average: a named vector with average precision (P), recall (R), specificity (S), F-measure (F), average F-measure (avF)
     and Accuracy (A) across examples;
    \item per.example: a named matrix with the Precision (P), Recall (R), Specificity (S), Accuracy (A), F-measure (F) and
     av.F-measure (av.F) for each example. Row names correspond to examples, column names correspond respectively to Precision (P), Recall (R),
     Specificity (S), Accuracy (A), F-measure (F) and av.F-measure (av.F);
  }
}
}
\description{
Method for computing Precision, Recall, Specificity, Accuracy and F-measure for multiclass and multilabel classification.
}
\details{
Names of rows and columns of \code{target} and \code{predicted} matrix must be provided in the same order, otherwise a stop message is returned.
}
\examples{
data(labels);
data(scores);
data(graph);
root <- root.node(g);
L <- L[,-which(colnames(L)==root)];
S <- S[,-which(colnames(S)==root)];
S[S>0.7] <- 1;
S[S<0.7] <- 0;
fscore <- F.measure.multilabel(L,S);
}
