% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{exponential_spheretime}
\alias{exponential_spheretime}
\alias{d_exponential_spheretime}
\title{Exponential covariance function on sphere x time}
\usage{
exponential_spheretime(covparms, lonlattime)

d_exponential_spheretime(covparms, lonlattime)
}
\arguments{
\item{covparms}{A vector with covariance parameters
in the form (variance, range_1, range_2, nugget), where range_1 is a 
spatial range (assuming sphere of radius 1), and range_2 is a temporal range.}

\item{lonlattime}{A matrix with \code{n} rows and three columns: longitudes in (-180,180),
latitudes in (-90,90), and times.
Each row of lonlattime describes a point on the sphere x time.}
}
\value{
A matrix with \code{n} rows and \code{n} columns, with the i,j entry
containing the covariance between observations at \code{lonlattime[i,]} and
\code{lonlattime[j,]}.
}
\description{
From a matrix of longitudes, latitudes, and times, and a vector covariance parameters of the form
(variance, range_1, range_2, nugget), return the square matrix of
all pairwise covariances.
}
\section{Functions}{
\itemize{
\item \code{d_exponential_spheretime()}: Derivatives with respect to parameters.

}}
\section{Covariances on spheres}{

The function first calculates the (x,y,z) 3D coordinates, and then inputs
the resulting locations into \code{exponential_spacetime}. This means that we construct
covariances on the sphere by embedding the sphere in a 3D space. There has been some
concern expressed in the literature that such embeddings may produce distortions.
The source and nature of such distortions has never been articulated,
and to date, no such distortions have been documented. Guinness and
Fuentes (2016) argue that 3D embeddings produce reasonable models for data on spheres.
}

