% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aic_grid.R
\name{aic.grid}
\alias{aic.grid}
\title{Calculates the AIC of a grid type copula}
\usage{
aic.grid(gc)
}
\arguments{
\item{gc}{a grid type copula object.}
}
\value{
Returns a number with the AIC of a grid type copula.
}
\description{
This function receives a grid type copula as a parameter and returns the value of the AIC.
}
\examples{
n <- 500
x <- rgamma(n,4,1/2)
e <- rnorm(n,0,.3)
y <- sin(x+e)
Fx <- ecdf(x)
Fy <- ecdf(y)
u <- Fx(x)
v <- Fy(y)
df <- cbind(u,v)
k <- 5
m <- 4
copula.grid <- estimate.gridCopula(U = df, k = k, m = m , method = "ml")
aic.grid(copula.grid)
}
