% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_uncertainty.R
\name{plot_uncertainty}
\alias{plot_uncertainty}
\title{Plot uncertainty}
\usage{
plot_uncertainty(model, paretoFront = NULL, type = "pn", lower, upper,
  resolution = 51, option = "mean", nintegpoints = 400)
}
\arguments{
\item{model}{list of objects of class \code{\link[DiceKriging]{km}}, one for each objective functions,}

\item{paretoFront}{(optional) matrix corresponding to the Pareto front of size \code{[n.pareto x n.obj]},}

\item{type}{type of uncertainty, for now only the probability of improvement over the Pareto front,}

\item{lower}{vector of lower bounds for the variables,}

\item{upper}{vector of upper bounds for the variables,}

\item{resolution}{grid size (the total number of points is \code{resolution^d}),}

\item{option}{optional argument (string) for n > 2 variables to define the projection type. The 3 possible values are "mean" (default), "max" and "min",}

\item{nintegpoints}{number of integration points for computation of mean, max and min values.}
}
\description{
Displays the probability of non-domination in the variable space. In dimension larger than two, projections in 2D subspaces are displayed.
}
\details{
Function inspired by the function \code{\link[KrigInv]{print_uncertainty}} and 
\code{\link[KrigInv]{print_uncertainty_nd}} from the package \code{\link[KrigInv]{KrigInv}}.
Non-dominated observations are represented with green diamonds, dominated ones by yellow triangles.
}
\examples{
\dontrun{ 
#---------------------------------------------------------------------------
# 2D, bi-objective function
#---------------------------------------------------------------------------
set.seed(25468)
n_var <- 2 
fname <- P1
lower <- rep(0, n_var)
upper <- rep(1, n_var)
res1 <- easyGParetoptim(fn=fname, lower=lower, upper=upper, budget=15, 
control=list(method="EHI", inneroptim="pso", maxit=20))

plot_uncertainty(res1$model, lower = lower, upper = upper)

#---------------------------------------------------------------------------
# 4D, bi-objective function
#---------------------------------------------------------------------------
set.seed(25468)
n_var <- 4
fname <- DTLZ2
lower <- rep(0, n_var)
upper <- rep(1, n_var)
res <- easyGParetoptim(fn=fname, lower=lower, upper=upper, budget = 40, 
control=list(method="EHI", inneroptim="pso", maxit=40))

plot_uncertainty(res$model, lower = lower, upper = upper, resolution = 31)
} 
}
