% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ConvenienceFunctions.R
\name{gapfill}
\alias{gapfill}
\alias{subsample}
\alias{resample}
\title{Interpolate, subsample and fill gaps in time series by linear interpolation}
\usage{
gapfill(x, dt = x[2, 1] - x[1, 1], units = c("auto", "secs", "mins",
  "hours", "days", "weeks"), type = "linear")

subsample(x, dt, units = c("auto", "secs", "mins", "hours", "days", "weeks"))

resample(x, dt, units = c("auto", "secs", "mins", "hours", "days", "weeks"))
}
\arguments{
\item{x}{Data frame with time in first column and time series data in
second.}

\item{dt}{Sampling interval. Default to time difference of first two observations}

\item{units}{Optional: units of \code{dt}. Only necessary when time is of class \code{POSIXt} and \code{dt} is not of class \code{difftime}.}

\item{type}{Type of interpolation. Only linear interpolation implemented}
}
\value{
A data frame with time and interpolated time series.
}
\description{
Interpolate, subsample and fill gaps in time series by linear interpolation

Subsample and interpolate oversampled or undersampled time series to obtain equidistant data at a lower or higher sampling frequency. Gaps are filled with linear interpolation
}
\details{
Subsampling, interpolating and gapfilling

An equidistant times series with sampling interval \code{dt} is created by linear interpolation. \code{gapfill} takes the time interval between the first and second observation as default value for \code{dt}. \code{subsample} and \code{resample} require a value of \code{dt}.
}
\examples{
plot(Hoernum, type="p", xlim=as.POSIXct(c("2008-08-01","2008-09-30")))
points(gapfill(Hoernum), type="p", pch=20, col="red", cex=0.2)
}
\author{
Tom Cox <tom.cox@uantwerp.be>
}
\keyword{utilities}
