% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_network.R
\name{plot_network}
\alias{plot_network}
\title{Plots of value-edged networks.}
\usage{
plot_network(sociomatrix, threshold = 0.5, save_pdf = FALSE,
  pdf_name = "Test.pdf", output_directory = "./",
  comparison_network = NULL, comparison_names = NULL, seed = NULL,
  white_background = FALSE, show_legend = TRUE, title = "",
  identical_node_positions = FALSE)
}
\arguments{
\item{sociomatrix}{A square numeric matrix (sociomatrix) with real valued edges
(no NA's).}

\item{threshold}{The threshold for removing edges from the network in order to
calculate the positions for the nodes using the Futcherman-Reingold algorithm.
The value is multiplied against max(abs(sociomatrix)) to determine the
threshold. Defaults to 0.5.}

\item{save_pdf}{Logical indicating whether the plot should be saved to a PDF.}

\item{pdf_name}{The name we would like to give to the output file. Be sure to
include a ".pdf" extension.}

\item{output_directory}{The directory where the user would like to output the
PDF if save_pdf == TRUE.}

\item{comparison_network}{An optional argument providing a second square
numeric matrix (sociomatrix) with real valued edges (no NA's) to be visually
compared to sociomatrix. The second network will be Procrustes transformed so
that it appears most similar without changing the relativel positions of
nodes. Defaults to NULL.}

\item{comparison_names}{An optional string vector of length two providing
titles for each of the two networks to be compared. Defaults to NULL.}

\item{seed}{Optional argument to set the seed for the network layout
algorithm so that plots look the same across multiple runs. Defaults to NULL
but can be a positive integer (eg. 12345).}

\item{white_background}{Defaults to FALSE. If TRUE, then network is plotted
on a white background with black lettering.}

\item{show_legend}{Logical indicating whether a legend with extremal edge
values should be shown. Defaults to TRUE.}

\item{title}{The title we wish to give our plot.}

\item{identical_node_positions}{Logical indicating whether node positions
should be fixed to be the same when comparing networks. Defaults to FALSE.}
}
\description{
Generates a visualization of a value-edged network.
}
\examples{
set.seed(12345)
sociomatrix <- matrix(rnorm(400,0,20),20,20)
colnames(sociomatrix) <- rownames(sociomatrix) <- letters[1:20]
plot_network(sociomatrix)
}
