% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGeneric.R, R/basisfns.R
\name{remove_basis}
\alias{remove_basis}
\alias{remove_basis,Basis,ANY-method}
\alias{remove_basis,Basis-method}
\alias{remove_basis,Basis,SpatialPolygons-method}
\title{Removes basis functions}
\usage{
remove_basis(Basis, rmidx)

\S4method{remove_basis}{Basis,ANY}(Basis, rmidx)

\S4method{remove_basis}{Basis,SpatialPolygons}(Basis, rmidx)
}
\arguments{
\item{Basis}{object of class \code{Basis}}

\item{rmidx}{indices of basis functions to remove. Or a \code{SpatialPolygons} object; basis functions overlapping this \code{SpatialPolygons} object will be \emph{retained}}
}
\description{
Takes an object of class \code{Basis} and returns an object of class \code{Basis} with selected basis functions removed
}
\examples{
library(sp)
df <- data.frame(x = rnorm(10),
                 y = rnorm(10))
coordinates(df) <- ~x+y
G <- auto_basis(plane(),df,nres=1)
data.frame(G) # Print info on basis

## Removing basis functions by index
G_subset <- remove_basis(G, 1:(nbasis(G)-1))
data.frame(G_subset)

## Removing basis functions using SpatialPolygons
x <- 1
poly <- Polygon(rbind(c(-x, -x), c(-x, x), c(x, x), c(x, -x), c(-x, -x)))
polys <- Polygons(list(poly), "1")
spatpolys <- SpatialPolygons(list(polys))
G_subset <- remove_basis(G, spatpolys)
data.frame(G_subset)
}
\seealso{
\code{\link{auto_basis}} for automatically constructing basis functions and \code{\link{show_basis}} for visualising basis functions
}
