% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculateCPProbabilities.R
\name{calculateCPProbabilities}
\alias{calculateCPProbabilities}
\title{Calculate the changepoint probabilities.}
\usage{
calculateCPProbabilities(network.samples)
}
\arguments{
\item{network.samples}{List of network and changepoint samples collected
during the MCMC simulation by \code{\link{EDISON.run}} and
\code{\link{runDBN}}.}
}
\value{
Returns a matrix of dimension NumNodes by NumTimePoints, where each
entry contains the marginal posterior probability of a changepoint for that
node at that timepoint.
}
\description{
This function calculates the marginal changepoint probabilities from the
changepoint samples taken during the MCMC simulation.
}
\examples{

# Generate random gene network and simulate data from it
dataset = simulateNetwork()

# Run MCMC simulation to infer networks and changepoint locations
result = EDISON.run(dataset$sim_data, num.iter=500)

# Calculate posterior probabilities of changepoints
cps = calculateCPProbabilities(result)

}
\author{
Frank Dondelinger
}

