% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_Dyadic.R
\docType{class}
\name{Dyadic-class}
\alias{Dyadic-class}
\title{The class to represent a dyadic matrix}
\value{
running \code{new("Dyadic")} return an object that belongs to the class \code{Dyadic},
with the initialization of the default values for the fields.
}
\description{
The main class in the \code{Dyadic}-package used for representing three types of dyadic matrices: horizontal, vertical,
symmetric, and asymmetric.
}
\section{Slots}{

\describe{
\item{\code{height}}{positive integer, the number of dyadic levels;}

\item{\code{breadth}}{positive integer, the breadth of the dyadic structure;}

\item{\code{type}}{string, one of the following character strings: \code{horiz},\code{vert},\code{symm}, \code{asymm} which
indicates the type of dyadic matrix
\itemize{
    \item \code{horiz} horizontal,
    \item \code{vert} vertical,
    \item \code{symm} symmetric,
    \item \code{asymm} asymmetric,
}
where the last two types distinguish symmetrically dyadic matrices (they both have symmetric dyadic structure)
that correspond to symmetric or not symmetric matrices.}

\item{\code{entries}}{list (of matrices); a list of the length \code{height} containing
\code{(2^(l)-1)*breadth x 2^(height-l)*breadth} matrices, where \code{l} is the index running through the list.
Each matrix in the list includes the entries corresponding to
\code{2^(height-l)} \code{(2^l-1)*breadth x breadth}-matrices
put side by side columnwise in the \code{l}th level of a dyadic structure.    In the 'symm'- and 'asymm'-cases, the terms below
diagonal on the diagonal blocks are set to zero.}

\item{\code{aentries}}{list (of matrices); a list which is either empty if the slot \code{type} is not \code{'asymm'}
or of the length \code{height} otherwise, in which the case it contains
\code{(2^(l)-1)*breadth x 2^(height-l)*breadth} matrices, where \code{l} is the index running through the list.
Each matrix in the list includes the entries corresponding to \code{2^(height-l)}.
\code{(2^l-1)*breadth x breadth}-matrices
put side by side columnwise in the \code{l}th horizontal level of an asymmetric dyadic structure.
The terms above and on the diagonal in the diagonal blocks are set to zero because they are accounted in the slot \code{entries}.}
}}

\section{References}{

Kos, M., Podgórski, K., & Wu, H. (2025). Dyadic Factorization and Efficient Inversion of Sparse Positive Definite Matrices. arXiv. https://arxiv.org/abs/2505.08144
}

\examples{
#-------------------------------------------------------------#
#------- Generating an object from the 'Dyadic' class --------#
#-------------------------------------------------------------#

# The most generic generation of an object of class 'Dyadic':
D <- new("Dyadic") # a generic format for 'Splinets' object
D
# The SLOTs of 'Dyadic' - the default values
D@height
D@breadth
D@type
D@entries[[1]]
D@aentries

N <- 4
k <- 3 # the height and breadth of a dyadic matrix

# The construction of a horizontally dyadic matrix with height 4 and breadth 3.

E <- list()
for (i in 1:4) {
    E[[i]] <- matrix(1, nrow = (2^(i) - 1) * 3, ncol = 2^(4 - i) * 3)
}


DD <- new("Dyadic", height = N, breadth = k, type = "horiz", entries = E)

DD

# The classic R matrix representation of DD.
mat_DD <- as.matrix(DD)
mat_DD
}
