% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph_info.R
\name{graph_info}
\alias{graph_info}
\title{Get metrics for a graph}
\usage{
graph_info(graph)
}
\arguments{
\item{graph}{a graph object of class
\code{dgr_graph}.}
}
\value{
a data frame containing metrics pertaining
to the graph
}
\description{
Get a data frame with metrics for a
graph.
}
\examples{
\dontrun{
# Import a GraphML graph file available in the
# DiagrammeR package
power_grid <-
  import_graph(
    system.file("examples/power_grid.graphml",
                package = "DiagrammeR"),
    graph_name = "p_grid")

# Display a data frame with graph information
graph_info(power_grid)
#>     name    n    e         dens min_deg max_deg avg_deg time tz
#> 1 p_grid 4941 6594 0.0005403027       1      19       3
}
}

