#' Icons and their download locations
#' @description Create a data frame with image icons
#' and their web addresses.
#' @param icon_name the name of the FontAwesome icon.
#' @export image_icon

image_icon <- function(icon_name) {

  if (grepl("fa.*", icon_name)) {

    icon_name <- gsub("fa-", "", icon_name)

    stub <- "http://visualizers.co/fa/black/512/"
    extension <- ".png"

    icon_names <- c(
      "adjust",
      "adn",
      "align-center",
      "align-justify",
      "align-left",
      "align-right",
      "ambulance",
      "anchor",
      "android",
      "angle-double-down",
      "angle-double-left",
      "angle-double-right",
      "angle-double-up",
      "angle-down",
      "angle-left",
      "angle-right",
      "angle-up",
      "apple",
      "archive",
      "arrow-circle-down",
      "arrow-circle-left",
      "arrow-circle-o-down",
      "arrow-circle-o-left",
      "arrow-circle-o-right",
      "arrow-circle-o-up",
      "arrow-circle-right",
      "arrow-circle-up",
      "arrow-down",
      "arrow-left",
      "arrow-right",
      "arrow-up",
      "arrows-alt",
      "arrows-h",
      "arrows-v",
      "arrows",
      "asterisk",
      "automobile",
      "backward",
      "ban",
      "bank",
      "bar-chart-o",
      "barcode",
      "bars",
      "beer",
      "behance-square",
      "behance",
      "bell-o",
      "bell",
      "bitbucket-square",
      "bitbucket",
      "bitcoin",
      "bold",
      "bolt",
      "bomb",
      "book",
      "bookmark-o",
      "bookmark",
      "briefcase",
      "btc",
      "bug",
      "building-o",
      "building",
      "bullhorn",
      "bullseye",
      "cab",
      "calendar-o",
      "calendar",
      "camera-retro",
      "camera",
      "car",
      "caret-down",
      "caret-left",
      "caret-right",
      "caret-square-o-down",
      "caret-square-o-left",
      "caret-square-o-right",
      "caret-square-o-up",
      "caret-up",
      "certificate",
      "chain-broken",
      "chain",
      "check-circle-o",
      "check-circle",
      "check-square-o",
      "check-square",
      "check",
      "chevron-circle-down",
      "chevron-circle-left",
      "chevron-circle-right",
      "chevron-circle-up",
      "chevron-down",
      "chevron-left",
      "chevron-right",
      "chevron-up",
      "child",
      "circle-o-notch",
      "circle-o",
      "circle-thin",
      "circle",
      "clipboard",
      "clock-o",
      "cloud-download",
      "cloud-upload",
      "cloud",
      "cny",
      "code-fork",
      "code",
      "codepen",
      "coffee",
      "cog",
      "cogs",
      "columns",
      "comment-o",
      "comment",
      "comments-o",
      "comments",
      "compass",
      "compress",
      "copy",
      "credit-card",
      "crop",
      "crosshairs",
      "css3",
      "cube",
      "cubes",
      "cut",
      "cutlery",
      "dashboard",
      "database",
      "dedent",
      "delicious",
      "desktop",
      "deviantart",
      "digg",
      "dollar",
      "dot-circle-o",
      "download",
      "dribbble",
      "dropbox",
      "drupal",
      "edit",
      "eject",
      "ellipsis-h",
      "ellipsis-v",
      "empire",
      "envelope-o",
      "envelope-square",
      "envelope",
      "eraser",
      "eur",
      "euro",
      "exchange",
      "exclamation-circle",
      "exclamation-triangle",
      "exclamation",
      "expand",
      "external-link-square",
      "external-link",
      "eye-slash",
      "eye",
      "facebook-square",
      "facebook",
      "fast-backward",
      "fast-forward",
      "fax",
      "female",
      "fighter-jet",
      "file-archive-o",
      "file-audio-o",
      "file-code-o",
      "file-excel-o",
      "file-image-o",
      "file-movie-o",
      "file-o",
      "file-pdf-o",
      "file-photo-o",
      "file-picture-o",
      "file-powerpoint-o",
      "file-sound-o",
      "file-text-o",
      "file-text",
      "file-video-o",
      "file-word-o",
      "file-zip-o",
      "file",
      "files-o",
      "film",
      "filter",
      "fire-extinguisher",
      "fire",
      "flag-checkered",
      "flag-o",
      "flag",
      "flash",
      "flask",
      "flickr",
      "floppy-o",
      "folder-o",
      "folder-open-o",
      "folder-open",
      "folder",
      "font",
      "forward",
      "foursquare",
      "frown-o",
      "gamepad",
      "gavel",
      "gbp",
      "ge",
      "gear",
      "gears",
      "gift",
      "git-square",
      "git",
      "github-alt",
      "github-square",
      "github",
      "gittip",
      "glass",
      "globe",
      "google-plus-square",
      "google-plus",
      "google",
      "graduation-cap",
      "group",
      "h-square",
      "hacker-news",
      "hand-o-down",
      "hand-o-left",
      "hand-o-right",
      "hand-o-up",
      "hdd-o",
      "header",
      "headphones",
      "heart-o",
      "heart",
      "history",
      "home",
      "hospital-o",
      "html5",
      "image",
      "inbox",
      "indent",
      "info-circle",
      "info",
      "inr",
      "instagram",
      "institution",
      "italic",
      "joomla",
      "jpy",
      "jsfiddle",
      "key",
      "keyboard-o",
      "krw",
      "language",
      "laptop",
      "leaf",
      "legal",
      "lemon-o",
      "level-down",
      "level-up",
      "life-bouy",
      "life-ring",
      "life-saver",
      "lightbulb-o",
      "link",
      "linkedin-square",
      "linkedin",
      "linux",
      "list-alt",
      "list-ol",
      "list-ul",
      "list",
      "location-arrow",
      "lock",
      "long-arrow-down",
      "long-arrow-left",
      "long-arrow-right",
      "long-arrow-up",
      "magic",
      "magnet",
      "mail-forward",
      "mail-reply-all",
      "mail-reply",
      "male",
      "map-marker",
      "maxcdn",
      "medkit",
      "meh-o",
      "microphone-slash",
      "microphone",
      "minus-circle",
      "minus-square-o",
      "minus-square",
      "minus",
      "mobile-phone",
      "mobile",
      "money",
      "moon-o",
      "mortar-board",
      "music",
      "navicon",
      "openid",
      "outdent",
      "pagelines",
      "paper-plane-o",
      "paper-plane",
      "paperclip",
      "paragraph",
      "paste",
      "pause",
      "paw",
      "pencil-square-o",
      "pencil-square",
      "pencil",
      "phone-square",
      "phone",
      "photo",
      "picture-o",
      "pied-piper-alt",
      "pied-piper-square",
      "pied-piper",
      "pinterest-square",
      "pinterest",
      "plane",
      "play-circle-o",
      "play-circle",
      "play",
      "plus-circle",
      "plus-square-o",
      "plus-square",
      "plus",
      "power-off",
      "print",
      "puzzle-piece",
      "qq",
      "qrcode",
      "question-circle",
      "question",
      "quote-left",
      "quote-right",
      "ra",
      "random",
      "rebel",
      "recycle",
      "reddit-square",
      "reddit",
      "refresh",
      "renren",
      "reorder",
      "repeat",
      "reply-all",
      "reply",
      "retweet",
      "rmb",
      "road",
      "rocket",
      "rotate-left",
      "rotate-right",
      "rouble",
      "rss-square",
      "rss",
      "rub",
      "ruble",
      "rupee",
      "save",
      "scissors",
      "search-minus",
      "search-plus",
      "search",
      "send-o",
      "send",
      "share-alt-square",
      "share-alt",
      "share-square-o",
      "share-square",
      "share",
      "shield",
      "shopping-cart",
      "sign-in",
      "sign-out",
      "signal",
      "sitemap",
      "skype",
      "slack",
      "sliders",
      "smile-o",
      "sort-alpha-asc",
      "sort-alpha-desc",
      "sort-amount-asc",
      "sort-amount-desc",
      "sort-asc",
      "sort-desc",
      "sort-down",
      "sort-numeric-asc",
      "sort-numeric-desc",
      "sort-up",
      "sort",
      "soundcloud",
      "space-shuttle",
      "spinner",
      "spoon",
      "spotify",
      "square-o",
      "square",
      "stack-exchange",
      "stack-overflow",
      "star-half-empty",
      "star-half-full",
      "star-half-o",
      "star-half",
      "star-o",
      "star",
      "steam-square",
      "steam",
      "step-backward",
      "step-forward",
      "stethoscope",
      "stop",
      "strikethrough",
      "stumbleupon-circle",
      "stumbleupon",
      "subscript",
      "suitcase",
      "sun-o",
      "superscript",
      "support",
      "table",
      "tablet",
      "tachometer",
      "tag",
      "tags",
      "tasks",
      "taxi",
      "tencent-weibo",
      "terminal",
      "text-height",
      "text-width",
      "th-large",
      "th-list",
      "th",
      "thumb-tack",
      "thumbs-down",
      "thumbs-o-down",
      "thumbs-o-up",
      "thumbs-up",
      "ticket",
      "times-circle-o",
      "times-circle",
      "times",
      "tint",
      "toggle-down",
      "toggle-left",
      "toggle-right",
      "toggle-up",
      "trash-o",
      "tree",
      "trello",
      "trophy",
      "truck",
      "try",
      "tumblr-square",
      "tumblr",
      "turkish-lira",
      "twitter-square",
      "twitter",
      "umbrella",
      "underline",
      "undo",
      "university",
      "unlink",
      "unlock-alt",
      "unlock",
      "unsorted",
      "upload",
      "usd",
      "user-md",
      "user",
      "users",
      "video-camera",
      "vimeo-square",
      "vine",
      "vk",
      "volume-down",
      "volume-off",
      "volume-up",
      "warning",
      "wechat",
      "weibo",
      "weixin",
      "wheelchair",
      "windows",
      "won",
      "wordpress",
      "wrench",
      "xing-square",
      "xing",
      "yahoo",
      "yen",
      "youtube-play",
      "youtube-square",
      "youtube")

    web_address <-
      paste0(stub, icon_names, extension)

    fa_icons <-
      as.data.frame(cbind(icon_names, web_address),
                    stringsAsFactors = FALSE)

    icon_address <-
      fa_icons[which(fa_icons[,1] == icon_name), 2]

    return(icon_address)
  }
}
