% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dt.remove.erroneous.characters.R
\name{dt.remove.erroneous.characters}
\alias{dt.remove.erroneous.characters}
\title{dt.remove.erroneous.characters}
\usage{
dt.remove.erroneous.characters(
  dt.name,
  threshold.for.numeric = 0.8,
  the.variables = ".",
  the.filter = NULL,
  variable.should.be = "numeric",
  value.for.missing = NULL,
  return.as = "result",
  envir = parent.frame(),
  ...
)
}
\arguments{
\item{dt.name}{a character value specifying the name of a data.frame or data.table object.}

\item{threshold.for.numeric}{a value between 0 and 1 specifying the maximum proportion of x that does not "look" numeric, e.g. "2.154" is a character value that can be converted to a numeric value.. If threshold.for.numeric = 0.1, then no more than 10 percent of the values in x can be values that do not "look" numeric.}

\item{the.variables}{a character vector specifying the variables that we want to apply a function to.  Only values that exist in names(dat) will be used; other values in the.variables will be excluded from the calculation.  When the.variables includes ".", then all values in names(dat) will be selected.  Values of the.variables that also exist in grouping.variables will be excluded from the.variables (but grouped by these values).}

\item{the.filter}{a character value, logical value, or expression stating the logical operations to be performed in filtering the data prior to calculating the.function.}

\item{variable.should.be}{a character vector specifying whether variable should be numeric or text or something else}

\item{value.for.missing}{a character value, logical value, or expression stating the logical operations to be performed in stating the missing value}

\item{return.as}{describes whether return should be result, code or mixture of both}

\item{envir}{the environment in which the code would be evaluated; parent.frame() by default.}

\item{...}{additional arguments to be passed}
}
\value{
The output of the function is contingent upon the 'return.as' parameter:
- If 'return.as' is "result", it returns a modified version of the input data frame or data table where erroneous characters in the specified variables are removed based on the given threshold. The function ensures that only values fitting the specified 'variable.should.be' criteria are retained, converting or imputing others as necessary, guided by the 'threshold.for.numeric' and 'value.for.missing' parameters.
- If 'return.as' is "code", it provides the R code or expressions that would perform this character removal and data cleaning, allowing users to review or manually execute the modifications.
- If another option is specified for 'return.as', the output may include both the cleaned data and the corresponding R code, depending on the specifics of the function’s implementation.

The function aims to sanitize data by eliminating or correcting values in specified variables that do not conform to the expected numeric or text formats, thereby enhancing data quality and consistency.
}
\description{
removes erroneous characters
}
