% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{rcomp}
\alias{rcomp}
\title{Conway-Maxwell-Poisson Random Sample}
\usage{
rcomp(n, lam, nu, sumTo = 100L)
}
\arguments{
\item{n}{an integer of the number of random samples to be taken.}

\item{lam}{a double of the parameter \eqn{\lambda}.}

\item{nu}{a double of the parameter \eqn{\nu}.}

\item{sumTo}{an integer for the summation term in the density (default 100).}
}
\value{
A random sample of size n.
}
\description{
Provides a size n sample from the Conway-Maxwell-Poisson
    distribution with parameters \code{lam} and \code{nu}. Sampling is done
    via a simple multinomial approach.
}
\details{
The function is only implemented for single values of \code{lam}
    and \code{nu}. See \code{\link{dcomp}} for details of the PDF.
}
\examples{
require(graphics)
sample <- rcomp(1000, 8.5, 0.9)
barplot(table(sample))
}
\author{
Jeffrey Pollock <jeffpollock9@gmail.com>
}
