% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Blanket_statsments.R
\name{blanket_statsments}
\alias{blanket_statsments}
\title{Run multiple different models with different sets of predictors}
\usage{
blanket_statsments(
  df,
  models_to_run,
  predictor_sets,
  covariates = c(),
  verbose = FALSE
)
}
\arguments{
\item{df}{data.frame containing the data set.}

\item{models_to_run}{either a named list or data.frame type, with every entry/row having the keys/columns outcome, modality, and event_censor}

\item{predictor_sets}{named list of lists containing the set of predictors. See blanket_stats for details}

\item{covariates}{vector of characters denoting columns with covariables}

\item{verbose}{logical. TRUE activates printout messages.}
}
\value{
named list of named lists of models
}
\description{
Wraps blanket_stats. Run a list of models with different modalities/outcomes for a list of different predictor sets with the same covariables.
}
\examples{
data <- survival::lung
models_to_run <- list('OS' = list(
'outcome' = 'time', 'modality' = 'cox', 'event_censor' = 'status'),
'weight_loss' = list('outcome' = 'wt.loss', 'modality' = 'linear', 'event_censor' = NA))
predictor_sets <- list('age' = c('age'),'age_ecog' = c('age', 'ph.ecog'))
covariates = c('sex')
bl_stats <- blanket_statsments(data, models_to_run, predictor_sets, covariates)

}
\author{
J. Peter Marquardt
}
