% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/organizeBirds.R
\name{createVisits}
\alias{createVisits}
\title{Create unique visits IDs}
\usage{
createVisits(
  x,
  idCols = c("locality", "recordedBy"),
  timeCols = c("day", "month", "year"),
  grid = NULL
)
}
\arguments{
\item{x}{An object of class \code{data.frame} or \code{SpatialPointsDataFrame}
including at least the columns specified that are used to identify a visit.}

\item{idCols}{A vector with the names of the columns other (than time columns)
that are used to identify a visit. This variable cannot be empty. At least the
recorders name or any other ID must be provided. Default is the Darwin Core
variables \code{c("locality", "recordedBy")}.}

\item{timeCols}{A vector with the names of the time columns that are used to
identify a visit.  If timeCols=NULL then time is ignored to create a visit ID.
Default is the Darwin Core variables \code{c("day", "month", "year")}.}

\item{grid}{Either \code{NULL} to be ignored or an object of class
\code{SpatialPolygons} or \code{SpatialPolygonsDataFrame} defining the maximum
 extent of visits effort. Then x must be an object of class SpatialPointsDataFrame}
}
\value{
A vector of the same length as the number of rows as the dataframe
  with a unique number for each combination of the values in the specified
  columns.
}
\description{
Takes a dataframe and a vector of column names and classifies each row of the
dataframe based on the combination of values in the specified columns.
}
\details{
What a visit should be is not always clearly defined and extractable in a
dataset. A reasonable assumption is that a visit could be identified from the
records made by one person on a certain day and at a specific location or site.
The default value for the variable column is therefore that a visit is identified
by the Darwin Core variables \code{c("locality", "day", "month", "year",
"recordedBy")}.
}
\examples{
OB <- organizeBirds(bombusObs)
tmp.vis <- createVisits(bombusObs,
                        idCols=c("locality", "recordedBy"),
                        timeCols=c("day", "month", "year"))
visits(OB, name = "visNoRecorder", useAsDefault = TRUE) <- tmp.vis
}
