% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BIEN.R
\name{BIEN_occurrence_species}
\alias{BIEN_occurrence_species}
\title{Extract occurrence data for specified species from BIEN}
\usage{
BIEN_occurrence_species(species, cultivated = FALSE, only.new.world = TRUE,
  all.taxonomy = FALSE, print.query = FALSE, native.status = FALSE,
  observation.type = FALSE, political.boundaries = FALSE, ...)
}
\arguments{
\item{species}{A single species, or a vector of species.  Genus and species should be separated by a space. Genus should be capitalized.}

\item{cultivated}{Return known cultivated records as well?  Default is FALSE.}

\item{only.new.world}{Return only records from the New World?  Default is true}

\item{all.taxonomy}{Return all taxonomic information?  This includes the raw data as well as the "scrubbed" data.}

\item{print.query}{Should the PostgreSQL query be printed? The default value is FALSE.}

\item{native.status}{Return information on introduction status?  The default value is FALSE. A value of TRUE also returns additional information on introduction status.}

\item{observation.type}{Return information on type of observation (i.e. specimen vs. plot)?  The default value is FALSE.}

\item{political.boundaries}{Return information on political boundaries for an observation? The default value is FALSE.}

\item{...}{Additional arguments passed to BIEN_sql}
}
\value{
Dataframe containing occurrence records for the specified species.
}
\description{
BIEN_occurrence_species downloads occurrence records for specific species from the BIEN database.
}
\examples{
\dontrun{
BIEN_occurrence_species("Abies amabilis")
species_vector<-c("Abies amabilis", "Acer nigrum")
BIEN_occurrence_species(species_vector)
BIEN_occurrence_species(species_vector,all.taxonomy=TRUE)}
}
\seealso{
Other occurrence functions: \code{\link{BIEN_occurrence_box}},
  \code{\link{BIEN_occurrence_country}},
  \code{\link{BIEN_occurrence_county}},
  \code{\link{BIEN_occurrence_family}},
  \code{\link{BIEN_occurrence_genus}},
  \code{\link{BIEN_occurrence_records_per_species}},
  \code{\link{BIEN_occurrence_shapefile}},
  \code{\link{BIEN_occurrence_state}}
}

