% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/transition.R
\docType{methods}
\name{transition}
\alias{transition}
\alias{transition-method}
\alias{transition,numeric,numeric-method}
\alias{transition,PhasesMCMC,missing-method}
\title{Transition Range Between Successive Phases}
\usage{
transition(x, y, ...)

\S4method{transition}{numeric,numeric}(x, y, level = 0.95)

\S4method{transition}{PhasesMCMC,missing}(x, level = 0.95)
}
\arguments{
\item{x, y}{A \code{\link{numeric}} vector. If \code{y} is missing, \code{x} must be an
\code{\linkS4class{PhasesMCMC}} object.}

\item{...}{Currently not used.}

\item{level}{A length-one \code{\link{numeric}} vector giving the confidence level.}
}
\value{
The endpoints of the transition interval for each pair of successive phases
(at a given \code{level}).
}
\description{
Estimates the transition endpoints between two phases.
}
\details{
The transition is the shortest interval that satisfies
\eqn{P(IntervalInf < Phase1Max < Phase2Min < IntervalSup | M) = level}.

This assumes that the phases are in temporal order constraint.
}
\section{Methods (by class)}{
\itemize{
\item \code{transition(x = numeric, y = numeric)}: Returns a length-two \code{\link{numeric}} vector
(terminal times of the transition interval).

\item \code{transition(x = PhasesMCMC, y = missing)}: Returns a \code{\linkS4class{TimeRange}} object.

}}
\examples{
## Coerce to events
eve <- as_events(mcmc_events, calendar = CE(), iteration = 1)
eve <- eve[1:10000, ]

## Compute min-max range by group
pha <- phases(eve, groups = list(A = c(1, 3), B = c(2, 4)))

## Compute phase ranges
bou <- boundaries(pha)
as.data.frame(bou)

## Compute phase transition
tra <- transition(pha)
as.data.frame(tra)

## Compute phase hiatus
hia <- hiatus(pha)
as.data.frame(hia)
}
\seealso{
Other time ranges: 
\code{\link{boundaries}()},
\code{\link{hiatus}()}
}
\author{
A. Philippe, M.-A. Vibet, N. Frerebeau
}
\concept{time ranges}
