% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Motif2TF_functions.R
\name{Factor_Motif_Plot}
\alias{Factor_Motif_Plot}
\title{Factor_Motif_Plot}
\usage{
Factor_Motif_Plot(
  seurat_object,
  TF_list,
  assay_RNA = "RNA",
  assay_maelstrom = "MotifTFanticor",
  logo_dir = "~/maelstrom/logos",
  col = c("darkred", "white", "darkgrey"),
  dim_reduction = "umap"
)
}
\arguments{
\item{seurat_object}{seurat object}

\item{TF_list}{list of TFs to plot the expression and linked motif Z-score for}

\item{assay_RNA}{RNA_count_assay assay containing the RNA data}

\item{assay_maelstrom}{maelstrom assay used for zscore vizualization, often either TFcor or TFanticor}

\item{logo_dir}{directory containing motif logos generated by gimme maelstrom}

\item{col}{colours used for zscore vizualization}

\item{dim_reduction}{dimensionality reduction method to use}
}
\value{
patchwork plot containing a expression dimreduction plot, a maelstrom motif score dimreduction plot, and a png image of the motif
}
\description{
plot both expression of a TF, and the motif accessibility of the associated motif. Finally, fetch the motif logo from the Maelstrom directory.
}
\examples{
sce_small <- readRDS(system.file("extdata","sce_small.Rds",package = 'AnanseSeurat'))
logos_dir_path <- system.file("extdata","maelstrom","logos",package = 'AnanseSeurat')
sce_small <- Factor_Motif_Plot(sce_small,
  c('gene1', 'gene2'),
  dim_reduction = 'pca',
  logo_dir = logos_dir_path)
}
