% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resolve.R
\name{resolve.data.frame}
\alias{resolve.data.frame}
\title{Resolve Guide for Data Frame}
\usage{
\method{resolve}{data.frame}(x, ...)
}
\arguments{
\item{x}{object}

\item{...}{passed arguments}
}
\value{
data.frame
}
\description{
Resolves implicit usage of default key 'guide' to
explicit usage for data.frame.
Simply calls \code{\link{explicit_guide}}
followed by \code{\link{factorize_codelist}}.
}
\examples{
library(magrittr)
file <- system.file(package = 'yamlet', 'extdata','quinidine.csv')
x <- decorate(file)
x \%>\% resolve(default = 'unit') \%>\% as_yamlet
}
\seealso{
Other resolve: \code{\link{ggready.data.frame}},
  \code{\link{ggready}}, \code{\link{resolve}}

Other interface: \code{\link{as_classified.factor}},
  \code{\link{conditionalize.data.frame}},
  \code{\link{decorate.character}},
  \code{\link{decorate.data.frame}},
  \code{\link{ggplot.decorated}},
  \code{\link{ggready.data.frame}},
  \code{\link{io_csv.character}},
  \code{\link{io_csv.data.frame}},
  \code{\link{io_table.character}},
  \code{\link{io_table.data.frame}},
  \code{\link{io_yamlet.character}},
  \code{\link{io_yamlet.data.frame}},
  \code{\link{is_parseable.default}},
  \code{\link{read_yamlet}}, \code{\link{write_yamlet}}
}
\concept{interface}
\concept{resolve}
