% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/agplot.R
\name{singularity}
\alias{singularity}
\title{Choose Singular Expression}
\usage{
singularity(x, data, ...)
}
\arguments{
\item{x}{list of expressions}

\item{data}{data.frame}

\item{...}{ignored}
}
\value{
integer, possibly NA
}
\description{
For a list of expressions evaluated on a data.frame
this returns the index of the one expression that evaluates
to an all-true vector (after coercing NA to FALSE).
Returns 0 if no expressions succeed, and NA_integer_ if
more than one succeed.
}
\examples{
meta <- system.file(package = 'yamlet', 'extdata','phenobarb.csv')
x <- read.csv(meta)
singularity(
  data = x,
  list(
    "event == 'conc'",
    "event == 'dose'",
    "event == 'metabolite'"
  )
)
singularity(
  data = x[x$event == 'dose',],
  list(
    "event == 'conc'",
    "event == 'dose'",
    "event == 'metabolite'"
  )
)
singularity(
  data = x[x$event == 'dose',],
  list(
    "time >= 0",
    "event == 'dose'"
  )
)
}
\seealso{
Other lab: 
\code{\link{agplot}()},
\code{\link{as_lab.list}()},
\code{\link{as_lab}()},
\code{\link{print.ag}()}
}
\concept{lab}
