% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readCsvBatch.R
\name{readCsvBatch}
\alias{readCsvBatch}
\title{Read batch of csv-files}
\usage{
readCsvBatch(
  fileNames = NULL,
  path = ".",
  fileFormat = "Eur",
  checkFormat = TRUE,
  returnArray = TRUE,
  columns = c("Plate", "Well", "StainA"),
  excludeFiles = "All infected plates",
  simpleNames = TRUE,
  minNamesLe = 4,
  silent = FALSE,
  debug = FALSE,
  callFrom = NULL
)
}
\arguments{
\item{fileNames}{(character) names of files to be read, if \code{NULL} all files fitting 'fileFormat'}

\item{path}{(character) where files should be read (folders should be written in R-style)}

\item{fileFormat}{(character) may be \code{NULL} (both US and European formats will be tried), 'Eur' or 'US'}

\item{checkFormat}{(logical) if \code{TRUE}: check header, remove empty columns, 1st line if all empmty, set output format for each file to matrix, if rownames are increasing integeres try to use 2nd of 'columns' as rownames}

\item{returnArray}{(logical) allows switching from array to list-output}

\item{columns}{(NULL or character) column-headers to be extracted (if specified), 2nd value may be comlumn with rownames (if rownames are encountered as increasing rownames)}

\item{excludeFiles}{(character) names of files to exclude (only used when reading all files of given directory)}

\item{simpleNames}{(logical) allows truncating names (from beginning) to get to variable part (using .trimFromStart()), but keeping 'minNamesLe'}

\item{minNamesLe}{(interger) min length of column-names if simpleNames=TRUE}

\item{silent}{(logical) suppress messages}

\item{debug}{(logical) additional messages for debugging}

\item{callFrom}{(character) allows easier tracking of messages produced}
}
\value{
This function returns an array (or list if \code{returnArray=FALSE}) of all numeric data read (numerical columns only) from individual files
}
\description{
This function was designed to read screening data split in parts (with common structure) and saved to multiple files,  
to extract the numeric columns and to compile all (numeric) data to a single array (or list).  Some screening platforms save results while progressing 
through a pile of microtiter-plates separately. The organization of the resultant files is structured through file-names and all files have exactely the same organization of lines and columns/ 
European or US-formatted csv files can be read, if argument \code{fileFormat} is \code{NULL} both types will be tested, otherwise it allows to specify a given format.
The presence of headers (to be used as column-names) may be tested using \code{checkFormat}.
}
\examples{
path1 <- system.file("extdata", package="wrMisc")
fiNa <-  c("pl01_1.csv","pl01_2.csv","pl02_1.csv","pl02_2.csv")
datAll <- readCsvBatch(fiNa, path1)
str(datAll)
## batch reading of all csv files in specified path :
datAll2 <- readCsvBatch(fileNames=NULL, path=path1, silent=TRUE)
}
\seealso{
\code{\link[utils]{read.table}}, \code{\link{writeCsv}}, \code{\link{readXlsxBatch}}
}
