% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vocab.R
\name{load_or_retrieve_vocab}
\alias{load_or_retrieve_vocab}
\title{Load a vocabulary file, or retrieve from cache}
\usage{
load_or_retrieve_vocab(vocab_file)
}
\arguments{
\item{vocab_file}{path to vocabulary file. File is assumed to be a text file,
with one token per line, with the line number corresponding to the index of
that token in the vocabulary.}
}
\value{
The vocab as a named integer vector. Names are tokens in vocabulary,
values are integer indices. The casedness of the vocabulary is inferred
and attached as the "is_cased" attribute.

Note that from the perspective of a neural net, the numeric indices \emph{are}
the tokens, and the mapping from token to index is fixed. If we changed the
indexing, it would break any pre-trained models. This is why the vocabulary
is stored as a named integer vector, and why it starts with index zero.
}
\description{
Load a vocabulary file, or retrieve from cache
}
