% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wbt_source.R
\name{wbt_source}
\alias{wbt_source}
\title{Initialize an R object containing spatial data for use by WhiteboxTools}
\usage{
wbt_source(
  x,
  dsn = NULL,
  layer = NULL,
  force = FALSE,
  verbose = wbt_verbose(),
  ...
)
}
\arguments{
\item{x}{A terra SpatVector or sf object, or a path to a file that can be read as a SpatVectorProxy}

\item{dsn}{Data source path / file name}

\item{layer}{Data layer}

\item{force}{Force write of vector data to file? Default: FALSE (only write if file does not exist)}

\item{verbose}{Print information about data source and contents?}

\item{...}{Additional arguments passed to \code{terra::writeVector()} or \code{sf::st_write()}}
}
\value{
An R object with attributes \code{wbt_dsn} and \code{wbt_layer} set as needed to support reading and writing R objects from file by WhiteboxTools.
}
\description{
Initialize an R object containing spatial data for use by WhiteboxTools
}
\keyword{General}
