% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generator.R
\name{gen_tbl}
\alias{gen_tbl}
\title{Generate a random tibble}
\usage{
gen_tbl(
  rows,
  cols = NULL,
  col_types = NULL,
  locale = default_locale(),
  missing = 0
)
}
\arguments{
\item{rows}{Number of rows to generate}

\item{cols}{Number of columns to generate, if \code{NULL} this is derived from \code{col_types}.}

\item{col_types}{One of \code{NULL}, a \code{\link[readr:cols]{cols()}} specification, or
a string. See \code{vignette("readr")} for more details.

If \code{NULL}, all column types will be imputed from the first 1000 rows
on the input. This is convenient (and fast), but not robust. If the
imputation fails, you'll need to supply the correct types yourself.

If a column specification created by \code{\link[readr:cols]{cols()}}, it must contain
one column specification for each column. If you only want to read a
subset of the columns, use \code{\link[readr:cols_only]{cols_only()}}.

Alternatively, you can use a compact string representation where each
character represents one column:
c = character, i = integer, n = number, d = double,
l = logical, f = factor, D = date, T = date time, t = time, ? = guess, or
\code{_}/\code{-} to skip the column.}

\item{locale}{The locale controls defaults that vary from place to place.
The default locale is US-centric (like R), but you can use
\code{\link[readr:locale]{locale()}} to create your own locale that controls things like
the default time zone, encoding, decimal mark, big mark, and day/month
names.}

\item{missing}{The percentage (from 0 to 1) of missing data to use}
}
\description{
This is useful for benchmarking, but also for bug reports when you cannot
share the real dataset.
}
\details{
There is also a family of functions to generate individual vectors of each
type.
}
\examples{
# random 10 x 5 table with random column types
rand_tbl <- gen_tbl(10, 5)
rand_tbl

# all double 25 x 4 table
dbl_tbl <- gen_tbl(25, 4, col_types = "dddd")
dbl_tbl

# Use the dots in long form column types to change the random function and options
types <- rep(times = 4, list(col_double(f = stats::runif, min = -10, max = 25)))
types
dbl_tbl2 <- gen_tbl(25, 4, col_types = types)
dbl_tbl2
}
\seealso{
\link{generators} to generate individual vectors.
}
