% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EC_functions.R
\name{vpr_save}
\alias{vpr_save}
\title{Save VPR data as an \link[oce]{as.oce} object}
\usage{
vpr_save(data, metadata)
}
\arguments{
\item{data}{a VPR data frame}

\item{metadata}{(optional) a named list of character values giving metadata
values. If this argument is not provided user will be prompted for a few
generic metadata requirements.}
}
\value{
an oce CTD object with all VPR data as well as metadata
}
\description{
Save VPR data as an \link[oce]{as.oce} object
}
\details{
This function will pass a VPR data frame object to an \code{oce} object.
Using an \code{oce} object as the default export format for VPR data allows for
metadata and data to be kept in the same, space efficient file, and avoid
redundancy in the data frame. The function check for data parameters that
may actually be metadata parameters (rows which have the same value
repeated for every observation). These parameters will automatically be
copied into the metadata slot of the \code{oce} object. The function will also
prompt for a variety of required metadata fields. Depending on specific
research / archiving requirements, these metadata parameters could be
updated by providing the argument \code{metadata}.

Default metadata parameters include 'deploymentType', 'waterDepth',
'serialNumber', 'latitude', 'longitude', 'castDate', 'castStartTime',
'castEndTime', 'processedBy', 'opticalSetting', 'imageVolume', 'comment'.
}
\examples{
data("taxa_conc_n")
metadata <- c('deploymentType' = 'towyo', 'waterDepth' =
max(ctd_roi_merge$pressure), 'serialNumber' = NA, 'latitude' = 47,
'longitude' = -65, 'castDate' = '2019-08-11', 'castStartTime'= '00:00',
'castEndTime' = '01:00', 'processedBy' = 'E. Chisholm', 'opticalSetting' =
'S2', 'imageVolume' = 83663, 'comment' = 'test data')

oce_dat <- vpr_save(taxa_conc_n, metadata)
# save(oce_dat, file = vpr_save.RData') # save data

}
