% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EC_functions.R
\name{vpr_ctd_read}
\alias{vpr_ctd_read}
\title{Read and format CTD VPR data}
\usage{
vpr_ctd_read(ctd_files, station_of_interest, day, hour, col_list)
}
\arguments{
\item{ctd_files}{full file paths to vpr ctd \code{.dat} files}

\item{station_of_interest}{VPR station name}

\item{day}{Day of interest, if not provided will be pulled from file path}

\item{hour}{Hour of interest, if not provided will be pulled from file path}

\item{col_list}{Optional list of CTD data column names}
}
\description{
Acts as a wrapper for \code{\link{ctd_df_cols}}
}
\details{
Reads CTD data and adds day, hour, and station information.
Calculates sigma T and depth variables from existing CTD data to supplement raw data.
If there are multiple hours of CTD data, combines them into single dataframe.

\strong{WARNING} \code{\link{ctd_df_cols}} is hard coded to accept a specific
order of CTD data columns. The names and values in these columns can change
based on the specific instrument and should be updated/confirmed before processing data
from a new VPR.
}
\examples{

station_of_interest <- 'test'

ctd_files <- system.file("extdata/COR2019002/rois/vpr5/d222", "h03ctd.dat",
package = "vprr", mustWork = TRUE)

ctd_dat_combine <- vpr_ctd_read(ctd_files, station_of_interest)

}
\author{
E. Chisholm & K. Sorochan
}
