% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cdc_rankedpairs.R
\name{cdc_rankedpairs}
\alias{cdc_rankedpairs}
\title{Ranked Pairs Method}
\usage{
cdc_rankedpairs(x, allow_dup = TRUE, min_valid = 1)
}
\arguments{
\item{x}{it accepts the following types of input:
1st, it can be an object of class \code{vote}. 
2nd, it can be a user-given Condorcet matrix, 
3rd, it can be a result of another Condorcet method, 
which is of class \code{condorcet}.}

\item{allow_dup}{whether ballots with duplicated score values 
are taken into account. Default is TRUE.}

\item{min_valid}{default is 1. If the number of valid entries of 
a ballot is less than this value, it will not be used.}
}
\value{
a \code{condorcet} object, which is essentially 
a list.
\itemize{
  \item (1) \code{call} the function call.
  \item (2) \code{method} the counting method.
  \item (3) \code{candidate} candidate names.
  \item (4) \code{candidate_num} number of candidate.
  \item (5) \code{ballot_num} number of ballots in x. When 
x is not a \code{vote} object, it may be NULL.
  \item (6) \code{valid_ballot_num} the number of ballots that are 
actually used to compute the result. When 
x is not a \code{vote} object, it may be NULL.
  \item (7) \code{winner} the winner, may be NULL.
  \item (8) \code{input_object} the class of x. 
  \item (9) \code{cdc} the Condorcet matrix which is actually used.
  \item (10) \code{dif} the score difference matrix. When 
x is not a \code{vote} object, it may be NULL.
  \item (11) \code{binary} win and loss recorded with 1 (win), 
0 (equal) and -1 (loss).
  \item (12) \code{summary_m} times of win (1), equal (0) 
and loss (-1).
  \item (13) \code{other_info} a list of 3 elements. The 1st 
is the reason of failure. If winner exists, it will be blank. The 2nd 
is the tally result (it may contain unsolved ties). 
The 3rd is the lock-in result; if the method fails, 
it will be NULL.
}
}
\description{
It is also called Tideman method. See details.
}
\details{
The method first summarizes the result of pairwise comparison, 
the order used is the order of winning votes from large to small. 
So if pairwise comparison has ties (that is, the number of voters 
who prefer a than b is equal to the number of voters who prefer 
b than a, the method will fail, and the winner will be NULL).

The second step is called tally. 
If a wins b with 100 votes, b wins c with 80 votes, then 
we put a-b-100 ahead of b-c-80. Suppose a wins b with 100 votes, 
a wins c with 100 votes, then we have a tie; so we have to check 
the relation between b and c. If b wins c, then we put a-c-100 
ahead of a-b-100. Suppose a wins b with 100 votes, d wins b with 
100 votes, then again we have a tie and have to check the a-d 
relation. If d wins a, then we put d-b-100 ahead of a-b-100. Suppose 
a wins b with 100 votes, e wins f with 100 votes, then the ties cannot 
be solved, so the winner will be NULL.

The third step, after the above mentioned tally, is called lock-in.
As the relations have been sorted according to their strength 
from large to small in the tally step, we now add them one 
by one. The rule is: if a relation is contradictory with those 
already locked in relations, this relation will be discarded.

For example, suppose we have already add relation a > b and 
b > c, then the two relations are locked in. As a result, we should 
not add b > a. Also, as a > b and b > c indicate a > c, so we should 
not add c > a. After this process, we will finally find the winner who 
defeats all others.
}
\examples{
raw <- c(
	"98:Abby>Cora>Erin>Dave>Brad",
	"64:Brad>Abby>Erin>Cora>Dave",
	"12:Brad>Abby>Erin>Dave>Cora", 
	"98:Brad>Erin>Abby>Cora>Dave", 
	"13:Brad>Erin>Abby>Dave>Cora", 
	"125:Brad>Erin>Dave>Abby>Cora", 
	"124:Cora>Abby>Erin>Dave>Brad", 
	"76:Cora>Erin>Abby>Dave>Brad", 
	"21:Dave>Abby>Brad>Erin>Cora", 
	"30:Dave>Brad>Abby>Erin>Cora", 
	"98:Dave>Brad>Erin>Cora>Abby", 
	"139:Dave>Cora>Abby>Brad>Erin", 
	"23:Dave>Cora>Brad>Abby>Erin"
) 
raw <- list2ballot(string = raw)
vote <- create_vote(raw, xtype = 3, candidate = c('Dave', 'Cora', 'Brad', 'Erin', 'Abby'))
win1 <- cdc_simple(vote) # no winner
win2 <- cdc_rankedpairs(vote) # winner is Brad
}
