% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/effects.R
\name{effect_metrics_one_cor}
\alias{effect_metrics_one_cor}
\title{Test whether the correlation is different from zero}
\usage{
effect_metrics_one_cor(
  data,
  col,
  cross,
  method = "pearson",
  labels = TRUE,
  clean = TRUE,
  ...
)
}
\arguments{
\item{data}{A tibble.}

\item{col}{The column holding metric values.}

\item{cross}{The column holding metric values to correlate.}

\item{method}{The output metrics, TRUE or pearson = Pearson's R, spearman = Spearman's rho.}

\item{labels}{If TRUE (default) extracts labels from the attributes, see \link{codebook}.}

\item{clean}{Prepare data by \link{data_clean}.}

\item{...}{Placeholder to allow calling the method with unused parameters from \link{effect_metrics}.}
}
\value{
A volker table containing the requested statistics.
}
\description{
The correlation is calculated using \code{stats::\link[stats:cor.test]{cor.test}}.
}
\examples{
library(volker)
data <- volker::chatgpt

effect_metrics_one_cor(data, sd_age, use_private, metric = TRUE)

}
\keyword{internal}
