% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/racusum_beta_sim.R
\name{racusum_beta_crit_sim}
\alias{racusum_beta_crit_sim}
\title{Compute alarm threshold of RA-CUSUM control charts using simulation}
\usage{
racusum_beta_crit_sim(
  L0,
  shape1,
  shape2,
  coeff,
  rs = 71,
  RA = 2,
  RQ = 1,
  nc = 1,
  hmax = 30,
  jmax = 4,
  m = 10000,
  verbose = FALSE
)
}
\arguments{
\item{L0}{Double. Prespecified in-control Average Run Length.}

\item{shape1}{Double. Shape parameter \eqn{\alpha}{alpha} \code{> 0} of the beta distribution.}

\item{shape2}{Double. Shape parameter \eqn{\beta}{beta} \code{> 0} of the beta distribution.}

\item{coeff}{Numeric Vector. Estimated coefficients \eqn{\alpha}{alpha} and \eqn{\beta}{beta}
from the binary logistic regression model.}

\item{rs}{Integer. Maximum risk score.}

\item{RA}{Double. Odds ratio of death under the alternative hypotheses. Detecting deterioration
in performance with increased mortality risk by doubling the odds Ratio \code{RA = 2}. Detecting
 improvement in performance with decreased mortality risk by halving the odds ratio of death
 \code{RA = 1/2}.}

\item{RQ}{Double. Defines the performance of a surgeon with the odds ratio ratio of death.
\code{Q}.}

\item{nc}{Integer. Number of cores used for parallel processing. Value is passed to
\code{\link{parSapply}}.}

\item{hmax}{Integer. Maximum value of \code{h} for the grid search.}

\item{jmax}{Integer. Number of digits for grid search.}

\item{m}{Integer. Number of simulation runs.}

\item{verbose}{Logical. If \code{TRUE} verbose output is included, if \code{FALSE} a quiet
calculation of \code{h} is done.}
}
\value{
Returns a single value which is the control limit \code{h} for a given in-control ARL.
}
\description{
Compute alarm threshold of risk-adjusted cumulative sum control charts using
 simulation.
}
\details{
Determines the control limit ("\code{h}") for given in-control ARL (\code{"L0"})
applying a grid search using \code{\link{racusum_beta_arl_sim}} and \code{\link{parSapply}}.
}
\examples{
\dontrun{
library(vlad)
racusum_beta_crit_sim(L0=500, shape1=1, shape2=3, coeff=c(-3.6798, 0.0768), RA = 2, rs = 71,
RQ = 1, verbose=TRUE, m=1e3)
}

}
\author{
Philipp Wittenberg
}
