% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chi.sq.R
\name{chi.sq}
\alias{chi.sq}
\title{Simplified Chi Square}
\usage{
chi.sq(df, var1, var2, correct = FALSE, post = FALSE, cramer = FALSE)
}
\arguments{
\item{df}{data frame to read in.}

\item{var1}{the dependent/outcome variable, \eqn{Y}.}

\item{var2}{the main independent/predictor variable, \eqn{X}.}

\item{correct}{logical (default set to \code{F}). When set to \code{correct = T}, will employ Yates' continuity correction (for data that violate the normality assumption).}

\item{post}{logical (default set to \code{F}). When set to \code{post = T}, will return results of post-hoc (Z) tests of the standardized residual for each cell (the standardized difference between observed and expected frequencies), using Bonferroni's alpha adjustment, and returns an adjusted p-value for each cell/comparison.}

\item{cramer}{logical (default set to \code{F}). When set to \code{post = T}, will return results of Cramer's V, a measure of the strength of the association between the two variables.}
}
\value{
This function returns the summary results table for a Pearson's Chi Square test, examining the relationship between \code{var1} from data frame \code{df}, and \code{var2}.
}
\description{
This function simplifies the call for Pearson's Chi Square test (chi.sq) on a given data frame.
}
\examples{
data <- mtcars

x2 <- chi.sq(data,vs,am)
summary(x2)

}
