% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ashdog.R
\name{get_uni_rep}
\alias{get_uni_rep}
\title{Get the representation of a discrete unimodal probability distribution.}
\usage{
get_uni_rep(probvec)
}
\arguments{
\item{probvec}{A probability vector. It assumes the probabilities
are ordered according to the ordering of the discrete set.}
}
\value{
A list with the following elements
\describe{
\item{\code{pivec}}{The mixing weights for the unimodal representation.}
\item{\code{mode}}{The central value of the unimodal distribution.}
}
}
\description{
NB: In \code{get_uni_rep}, we count the mode starting at 1.
    In \code{\link{get_probk_vec}}, we count the mode starting at 0.
}
\seealso{
\code{\link{get_probk_vec}} with option \code{model = "ash"}
    for the inverse of this function.
}
\author{
David Gerard
}
