
test.parboot.occu <- function() {
  
  set.seed(6546)
  R <- 20
  J <- 5
  z <- rbinom(R, 1, 0.6)
  y <- matrix(NA, R, J)
  y[] <- rbinom(R*J, 1, z*0.7)
  x1 <- rnorm(R)
  x2 <- y
  x2[] <- rnorm(R*J)
  x2[1,] <- NA
  x2[3,1] <- NA
  umf <- unmarkedFrameOccu(y=y, siteCovs=data.frame(x1=x1),
                           obsCovs=list(x2=x2))
  
  fitstats <- function(fm) {
    observed <- getY(fm@data)
    expected <- fitted(fm)
    resids <- residuals(fm)
    sse <- sum(resids^2,na.rm=TRUE)
    chisq <- sum((observed - expected)^2 / expected,na.rm=TRUE)
    freeTuke <- sum((sqrt(observed) - sqrt(expected))^2,na.rm=TRUE)
    out <- c(SSE=sse, Chisq=chisq, freemanTukey=freeTuke)
    return(out)
  }
  
  fm1 <- occu(~x2 ~x1, umf)
  gof <- parboot(fm1, fitstats, nsim = 100, seed = 6546)

  checkEquals(gof@t.star,
              structure(c(18.7746866002624, 20.9966817425225, 21.0915126770059, 
                          15.4856774216373, 18.0581719792348, 21.4525274414677, 18.3202732437013, 
                          18.0329951738709, 16.0589173337638, 19.7871002447359, 17.2459365918171, 
                          20.9180161863224, 21.4887230414208, 14.4001424217343, 16.017855606485, 
                          18.3958870221094, 17.0206184727914, 14.2033266244206, 22.1456241418365, 
                          14.1564507455632, 14.4706844994352, 18.2558169062216, 20.5154824111089, 
                          17.9941423421039, 22.18282926607, 22.8570196007432, 19.366367553137, 
                          20.4962852021942, 14.251865854916, 20.3989627385653, 21.4505117438051, 
                          22.0520962021956, 21.0259765238425, 13.0910443480409, 17.904578073789, 
                          22.0710826695798, 14.6142609903255, 18.4141775043238, 21.3328625910512, 
                          21.3405144669319, 18.7325324529252, 19.3849746578571, 20.3590485320187, 
                          20.4040202118265, 23.1480892686535, 20.1469421723763, 12.5105719150507, 
                          20.437249767194, 19.1742999102407, 16.1516658111056, 20.5912497555244, 
                          21.84989878063, 23.2753175602652, 23.3814830975566, 21.1089606931482, 
                          18.6180453262704, 21.837522910361, 18.377500510363, 10.1309402984789, 
                          19.2731595026705, 21.3095370447816, 20.1833368923955, 13.7818438704599, 
                          22.8569732174275, 22.2142385817516, 21.8153610930171, 19.1539359239755, 
                          23.1858175901201, 20.9572440809444, 19.6090159183138, 17.8510899122887, 
                          20.780782977581, 20.8265295454964, 17.2392134560465, 15.0957443939014, 
                          16.7710439244229, 21.1651749219997, 13.1386509440353, 23.2031848835048, 
                          22.1272289816147, 20.1618368975827, 19.6587766755318, 20.9908928821342, 
                          19.596659322039, 23.2459217236841, 14.6560075872156, 12.9706897401378, 
                          22.1358662794675, 15.5211676614858, 15.4622131605339, 20.3346867767006, 
                          18.1554426115242, 14.9658897617565, 14.8296575729766, 18.5927532361386, 
                          17.5166811893318, 17.4915099451517, 18.9194486639491, 16.6775659413074, 
                          20.6960373337144, 52.3631944701757, 48.9017045383232, 61.2162269950553, 
                          78.4002042720537, 70.7350395641339, 56.2927873911599, 62.536873876919, 
                          59.9451136128161, 70.8743433829963, 70.0375405613271, 67.8951872822006, 
                          60.1285602924579, 58.4165294525751, 55.9068144554297, 100.475177096736, 
                          76.7715932695216, 75.1722732831206, 86.7211582959508, 53.1938517701337, 
                          64.2996450378078, 74.1096527991574, 60.5803177516506, 52.4732935638143, 
                          57.2746602315961, 56.0634248068869, 60.9156811674108, 69.5159811215135, 
                          63.0811305434309, 58.5217303732609, 52.4012330222917, 43.9628800687451, 
                          52.0232904822657, 49.8956269443306, 68.3893121127482, 59.1306566133885, 
                          59.5249024125244, 67.9732483464269, 59.398446306474, 49.8723888929367, 
                          55.390804394885, 64.8546850533554, 67.2665565819125, 60.5229368226271, 
                          55.5494824583955, 55.205216470226, 60.9642803977633, 78.4905379242811, 
                          59.0909633232641, 73.3896275322904, 59.8229437934273, 50.4563475476144, 
                          47.8164081210436, 49.6601642697863, 48.7303253602977, 61.5056541993943, 
                          65.9175822594495, 59.5805531569101, 65.6579880489724, 31.9405877422024, 
                          68.1081523001706, 66.3286143329512, 60.7686002783782, 80.7693821719439, 
                          52.1407917508793, 50.1230422223557, 42.2591373361357, 65.4747743175055, 
                          43.3552120588477, 64.3629022057392, 64.9823569529455, 67.0751550907628, 
                          58.4101632341376, 61.2294805311998, 69.7691192966248, 72.0929454488691, 
                          62.5232252342253, 58.2457016618973, 61.525939411103, 50.4711755467122, 
                          57.6532210476991, 50.6080776935378, 65.5037370843446, 53.0754269261736, 
                          64.5867894016215, 46.0724301506294, 73.4423615042101, 76.1265957326063, 
                          54.4405104045667, 66.9801024858028, 68.604171109274, 64.637758173449, 
                          71.2107058578072, 75.8381938953166, 73.3705050322326, 60.2224073528547, 
                          71.3297935239, 70.8495883403043, 65.6836730723372, 68.8983022029438, 
                          55.9495643881621, 23.1872796796412, 25.5172988269584, 26.4065100226276, 
                          21.4278258171779, 24.5772179839936, 26.6042987907175, 22.5834539466764, 
                          22.6674380916236, 21.7435415980798, 25.4532200765034, 23.062448733056, 
                          26.0052910859346, 26.9597169632636, 19.0275374068362, 21.470917650961, 
                          24.5663460238737, 22.3212129177263, 19.9277817360688, 26.724339434433, 
                          18.560690991229, 18.72420761907, 22.849509039812, 24.9410659400152, 
                          22.6421528047931, 27.3947051636854, 27.8058161467038, 25.4135837747287, 
                          26.5522281641876, 19.0697537219016, 25.3289291695782, 25.0047063925678, 
                          26.4107134596705, 25.2819417202627, 17.2637327469138, 22.5840138928072, 
                          26.9444601571609, 19.5243370947845, 22.9200257118672, 25.4864720811944, 
                          26.4683674721023, 24.1162186681747, 24.692704202788, 25.6643442367561, 
                          25.0756980414783, 28.0203741665195, 25.5708328569422, 17.8707220107135, 
                          25.420036133941, 24.1676594930821, 20.2052743906418, 24.6348361756441, 
                          25.5911029723749, 27.702417923666, 27.7309403921646, 26.6830004680968, 
                          23.2771590809151, 26.9423780885437, 22.9385727479605, 12.8543346177069, 
                          25.2264907812751, 26.0749309599233, 26.3667833150263, 19.4106706428392, 
                          27.3406020144126, 26.8776521268784, 25.3645596265614, 24.7423163170246, 
                          26.5778224687491, 27.0439344241447, 25.2255049721209, 23.8475070360257, 
                          25.9492282080674, 25.603523314214, 22.6862126544767, 20.6262360156608, 
                          21.4676734167549, 26.2214709288187, 15.485494176506, 27.8146027595266, 
                          27.4258990188062, 24.8713909557762, 24.4057272178812, 26.0924148095142, 
                          25.1988921130371, 27.3142364017856, 20.0906644928645, 17.3131000777329, 
                          26.834581797999, 21.4308582739132, 21.3989946592156, 25.820347211862, 
                          24.37019768179, 20.5029636219238, 20.1679846820728, 23.1941862702801, 
                          23.3831691548312, 22.9016209356797, 25.0308649224961, 22.251771906931, 
                          25.8338217376701), .Dim = c(100L, 3L), 
                        .Dimnames = list(NULL, c("SSE", "Chisq", "freemanTukey"))))
}