% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Ottawa.R
\docType{data}
\name{uottawa}
\alias{uottawa}
\title{Colors of the University of Ottawa, Canada}
\format{
An object of class \code{character} of length 8.
}
\source{
Color definitions are based on UOttawa's 
\href{https://www.uottawa.ca/about-us/administration-services/brand}{brand specifications}.
}
\usage{
uottawa
}
\value{
A named vector of colors (HEX/HTML codes of type character).
}
\description{
\code{uottawa} provides the two primary colors and the six secondary colors
of the \href{https://www.uottawa.ca/en}{University of Ottawa}, Canada.
}
\details{
The two primary colors are
\code{"garnet"} (defined as RGB 143/0/26, HEX #8F001A) and
\code{"grey_ottawa"} (defined as RGB 128/116/108, HEX #80746C).

The secondary colors are
\code{"charcoal"} (defined as RGB 45/45/44, HEX #2D2D2C),
\code{"grey_blue"} (defined as RGB 99/109/119, HEX #636d77),
\code{"green_ottawa"} (defined as RGB 103/121/108, HEX #67796C),
\code{"polar_grey"} (defined as RGB 242/242/242, HEX #F2F2F2),
\code{"light_grey_ottawa"} (defined as RGB 172/163/154, HEX #ACA39A), and
\code{"cool_grey"} (defined as RGB 200/201/199, HEX #C8C9C7). 

\code{uottawa} uses the HEX color definitions.
}
\examples{
uottawa
unikn::seecol(uottawa, main = "Colors of UOttawa") # view color palette

}
\seealso{
\code{\link{seecol}} for viewing and comparing color palettes;
\code{\link{usecol}} for using color palettes;
\code{\link{simcol}} for finding similar colors;
\code{\link{newpal}} for defining new color palettes;
\code{\link{grepal}} for finding named colors.

Other Canadian university color palettes: 
\code{\link{carleton}},
\code{\link{concordia_1}},
\code{\link{concordia_2}},
\code{\link{concordia_3}},
\code{\link{concordia_4}},
\code{\link{guelph}},
\code{\link{laval}},
\code{\link{manitoba_1}},
\code{\link{manitoba_2}},
\code{\link{mcgill_brights}},
\code{\link{mcgill_darks}},
\code{\link{mcgill_grey}},
\code{\link{mcgill_muted}},
\code{\link{mcgill_pastels}},
\code{\link{mcgill_red}},
\code{\link{mcmaster_brighterworld}},
\code{\link{mcmaster_heritage}},
\code{\link{mun_1}},
\code{\link{mun_2}},
\code{\link{queensu_1}},
\code{\link{queensu_2}},
\code{\link{sfu_brand}},
\code{\link{ubc}},
\code{\link{ucalgary_1}},
\code{\link{ucalgary_2}},
\code{\link{ucalgary_accent}},
\code{\link{ucalgary_warmgreys}},
\code{\link{utoronto}},
\code{\link{uvic_1}},
\code{\link{uvic_2}},
\code{\link{uwaterloo_arts}},
\code{\link{uwaterloo_engineering}},
\code{\link{uwaterloo_environment}},
\code{\link{uwaterloo_health}},
\code{\link{uwaterloo_main}},
\code{\link{uwaterloo_math}},
\code{\link{uwaterloo_science}},
\code{\link{western_uni}},
\code{\link{yorku_1}},
\code{\link{yorku_2}}
}
\author{
\strong{unicol}, 2023-07-04.
}
\concept{Canadian university color palettes}
\keyword{datasets}
