% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc_and_utility.R
\name{noNAs}
\alias{noNAs}
\title{Succinctly select complete rows from a dataframe}
\usage{
noNAs(df, rows = NULL, cols = NULL, drop = TRUE)
}
\arguments{
\item{df}{an \code{\link[=data.frame]{data.frame()}} to select on}

\item{rows}{Rows to keep (optional, incomplete rows still discarded)}

\item{cols}{Cols to keep}

\item{drop}{Whether to return a vector when only 1 column is selected (default TRUE)}
}
\value{
\itemize{
\item Complete rows and (optionally) selected columns
}
}
\description{
Succinctly select complete rows from a dataframe.
}
\examples{
tmp = mtcars
tmp[2,1] = NA
noNAs(tmp, cols="mpg")
noNAs(tmp, cols="mpg", drop = FALSE)
noNAs(tmp) # no Mazda RX4 Wag

}
\seealso{
Other Data Functions: 
\code{\link{umxFactor}()},
\code{\link{umxHetCor}()},
\code{\link{umx_as_numeric}()},
\code{\link{umx_cont_2_quantiles}()},
\code{\link{umx_lower2full}()},
\code{\link{umx_make_MR_data}()},
\code{\link{umx_make_TwinData}()},
\code{\link{umx_make_fake_data}()},
\code{\link{umx_make_raw_from_cov}()},
\code{\link{umx_polychoric}()},
\code{\link{umx_polypairwise}()},
\code{\link{umx_polytriowise}()},
\code{\link{umx_read_lower}()},
\code{\link{umx_read_prolific_demog}()},
\code{\link{umx_rename}()},
\code{\link{umx_reorder}()},
\code{\link{umx_score_scale}()},
\code{\link{umx_select_valid}()},
\code{\link{umx_stack}()},
\code{\link{umx}}
}
\concept{Data Functions}
