% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_run_modify.r
\name{umxModify}
\alias{umxModify}
\alias{umxReRun}
\title{umxModify: Add, set, or drop model paths by label.}
\usage{
umxModify(lastFit, update = NULL, master = NULL, regex = FALSE,
  free = FALSE, value = 0, freeToStart = NA, name = NULL,
  verbose = FALSE, intervals = FALSE, comparison = FALSE,
  autoRun = TRUE, dropList = "deprecated")
}
\arguments{
\item{lastFit}{The \code{\link{mxModel}} you wish to update and run.}

\item{update}{What to update before re-running. Can be a list of labels, a regular expression (set regex = TRUE) or an object such as mxCI etc.}

\item{master}{If you set master, then the labels in update will be equated (slaved) to those provided in master.}

\item{regex}{Whether or not update is a regular expression (defaults to FALSE). If you provide a string, it
over-rides the contents of update, and sets regex to TRUE.}

\item{free}{The state to set "free" to for the parameters whose labels you specify (defaults to free = FALSE, i.e., fixed)}

\item{value}{The value to set the parameters whose labels you specify too (defaults to 0)}

\item{freeToStart}{Whether to update parameters based on their current free-state. free = c(TRUE, FALSE, NA), (defaults to NA - i.e, not checked)}

\item{name}{The name for the new model}

\item{verbose}{How much feedback to give}

\item{intervals}{Whether to run confidence intervals (see \code{\link{mxRun}})}

\item{comparison}{Whether to run umxCompare() after umxRun}

\item{autoRun}{Whether to run the modified model before returning it (default), or just to modify and return without running.}

\item{dropList}{(deprecated: use 'update' instead.}
}
\value{
- \code{\link{mxModel}}
}
\description{
umxModify allows you to modify, re-run and summarize an \code{\link{mxModel}},
all in one line of script. 
You can add paths, or other model elements, set paths or drop them.
As an example, this one-liner drops a path labelled "Cs", and returns the updated model:
}
\details{
\code{fit2 = umxModify(fit1, update = "Cs", name = "newModelName", comparison = TRUE)}

Regular expressions are a powerful feature: they let you drop collections of paths by matching patterns
fit2 = umxModify(fit1, regex = "C[sr]", name = "drop_Cs_and_Cr", comparison = TRUE)

If you are just starting out, you might find it easier to be more explicit. Like this:

fit2 = omxSetParameters(fit1, labels = "Cs", values = 0, free = FALSE, name = "newModelName")
fit2 = mxRun(fit2)
summary(fit2)
}
\examples{
require(umx)
data(demoOneFactor)
latents  = c("G")
manifests = names(demoOneFactor)
umx_set_optimizer("SLSQP")

m1 <- mxModel("One Factor", type = "RAM", 
	manifestVars = manifests, latentVars = latents, 
	mxPath(from = latents, to = manifests),
	mxPath(from = manifests, arrows = 2),
	mxPath(from = latents, arrows = 2, free = FALSE, values = 1.0),
	mxData(cov(demoOneFactor), type = "cov", numObs = 500)
)
m1 = umxRun(m1, setLabels = TRUE, setValues = TRUE)
m2 = umxModify(m1, update = "G_to_x1", name = "drop_X1")
umxSummary(m2); umxCompare(m1, m2)
# 1-line version including comparison
m2 = umxModify(m1, update = "G_to_x1", name = "drop_X1", comparison = TRUE)
# use regular expression to drop multiple paths: e.g. G to x3, x4, x5
m2 = umxModify(m1, update = "^G_to_x[3-5]", regex = TRUE, name = "no_G_to_x3_5", comp = TRUE)
# Same, but shorter
m2 = umxModify(m1, regex  = "^G_to_x[3-5]", name = "no_G_to_x3_5")
# Same, but don't autoRun
m2 = umxModify(m1, regex  = "^G_to_x[3-5]", name = "no_G_to_x3_5", autoRun = FALSE) 
m2 = umxModify(m1, update = "G_to_x1", value = .2, name = "fix_G_x1_at_point2", comp = TRUE)
m3 = umxModify(m2, update = "G_to_x1", free = TRUE, name = "free_G_x1_again", comparison = TRUE)
}
\references{
- \url{http://github.com/tbates/umx}
}
