% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ubiquity.R
\name{simulate_subjects}
\alias{simulate_subjects}
\title{Run Population Simulations}
\usage{
simulate_subjects(
  parameters,
  cfg,
  show_progress = TRUE,
  progress_message = "Simulating Subjects:"
)
}
\arguments{
\item{parameters}{list containing the typical value of parameters}

\item{cfg}{ubiquity system object}

\item{show_progress}{Boolean value controlling the display of a progress indicator (\code{TRUE})}

\item{progress_message}{text string to prepend when called from the ShinyApp}
}
\value{
Mapped simulation output with individual predictions, individual
parameters, and summary statistics of the parameters. The Vignettes below
details on the format of the output.
}
\description{
Used to run Population/Monte Carlo simulations with subjects
generated from either provided variance/covariance information or a dataset.
}
\details{
Failures due to numerical instability or other integration errors will be
captured within the function. Data for those subjects will be removed from the
output. Their IDs will be displayed as messages and stored in the output. 


For more information on setting options for population simulation see the
stochastic section of the \code{\link{system_set_option}} help file.
}
\seealso{
Vignette on simulation (\code{vignette("Simulation", package = "ubiquity")}) titration (\code{vignette("Titration", package = "ubiquity")}) as well as \code{\link{som_to_df}}
}
